/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.index.tree;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.sis.index.tree.NodeIterator;
import org.apache.sis.index.tree.PointTreeNode;
import org.apache.sis.index.tree.QuadTreeNode;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PointTree<E>
extends AbstractSet<E>
implements CheckedContainer<E>,
Serializable {
    private static final long serialVersionUID = 488727778652772913L;
    public static final int MAXIMUM_DIMENSIONS = 6;
    private final Class<E> elementType;
    private final CoordinateReferenceSystem crs;
    final PointTreeNode root;
    private final int nodeCapacity;
    private long count;
    final double[] treeRegion;
    final Locator<? super E> locator;
    private final boolean parallel;

    public PointTree(PointTree<E> pointTree) {
        this.root = (PointTreeNode)pointTree.root.clone();
        this.elementType = pointTree.elementType;
        this.crs = pointTree.crs;
        this.nodeCapacity = pointTree.nodeCapacity;
        this.count = pointTree.count;
        this.treeRegion = pointTree.treeRegion;
        this.locator = pointTree.locator;
        this.parallel = pointTree.parallel;
    }

    public PointTree(Class<E> clazz, Envelope envelope, Locator<? super E> locator, int n, boolean bl) {
        ArgumentChecks.ensureNonNull("elementType", clazz);
        ArgumentChecks.ensureNonNull("bounds", envelope);
        ArgumentChecks.ensureNonNull("locator", locator);
        ArgumentChecks.ensureStrictlyPositive("nodeCapacity", n);
        int n2 = envelope.getDimension();
        if (n2 > 6) {
            throw new IllegalArgumentException(Errors.format((short)37, n2));
        }
        this.treeRegion = new double[n2 * 2];
        boolean bl2 = n2 >= 2;
        for (int i = 0; i < n2; ++i) {
            double d = this.treeRegion[i] = envelope.getMedian(i);
            double d2 = envelope.getSpan(i);
            this.treeRegion[i + n2] = d2;
            double d3 = d2;
            bl2 &= !Double.isNaN(d) && d3 > 0.0;
            if (!Double.isInfinite(d) && !Double.isInfinite(d3)) continue;
            throw new IllegalArgumentException(Errors.format((short)73, "treeRegion"));
        }
        if (!bl2) {
            throw new IllegalArgumentException(Errors.format((short)31));
        }
        this.crs = envelope.getCoordinateReferenceSystem();
        this.elementType = clazz;
        this.nodeCapacity = Math.max(4, n);
        this.locator = locator;
        this.root = n2 == 2 ? new QuadTreeNode() : new PointTreeNode.Default(n2);
        this.parallel = bl;
    }

    public final Optional<CoordinateReferenceSystem> getCoordinateReferenceSystem() {
        return Optional.ofNullable(this.crs);
    }

    public final int getDimension() {
        return this.treeRegion.length >>> 1;
    }

    @Override
    public final Class<E> getElementType() {
        return this.elementType;
    }

    @Override
    public void clear() {
        this.root.clear();
        this.count = 0L;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0L;
    }

    @Override
    public int size() {
        return this.count >>> 32 == 0L ? (int)this.count : Integer.MAX_VALUE;
    }

    @Override
    public boolean add(E e) {
        ArgumentChecks.ensureNonNull("element", e);
        boolean bl = this.insert(this.root, this.treeRegion, e, new double[this.getDimension()]);
        if (bl) {
            ++this.count;
        }
        return bl;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        ArgumentChecks.ensureNonNull("elements", collection);
        double[] dArray = new double[this.getDimension()];
        boolean bl = false;
        int n = 0;
        for (E e : collection) {
            ArgumentChecks.ensureNonNullElement("element", n++, e);
            if (!this.insert(this.root, this.treeRegion, e, dArray)) continue;
            bl = true;
            ++this.count;
        }
        return bl;
    }

    private boolean insert(PointTreeNode pointTreeNode, double[] dArray, E e, double[] dArray2) {
        boolean bl = false;
        this.locator.getPositionOf(e, dArray2);
        while (true) {
            int n;
            Object object;
            if ((object = pointTreeNode.getChild(n = PointTreeNode.quadrant(dArray2, dArray))) == null) {
                pointTreeNode.setChild(n, new Object[]{e});
                return true;
            }
            if (object instanceof PointTreeNode) {
                if (!bl) {
                    bl = true;
                    dArray = (double[])dArray.clone();
                }
                PointTreeNode.enterQuadrant(dArray, n);
                pointTreeNode = (PointTreeNode)object;
                continue;
            }
            Object[] objectArray = (Object[])object;
            int n2 = objectArray.length;
            for (int i = 0; i < n2; ++i) {
                if (!e.equals(objectArray[i])) continue;
                return false;
            }
            if (n2 < this.nodeCapacity) {
                Object[] objectArray2 = new Object[n2 + 1];
                System.arraycopy(objectArray, 0, objectArray2, 0, n2);
                objectArray2[n2] = e;
                pointTreeNode.setChild(n, objectArray2);
                return true;
            }
            if (!bl) {
                bl = true;
                dArray = (double[])dArray.clone();
            }
            PointTreeNode.enterQuadrant(dArray, n);
            PointTreeNode pointTreeNode2 = pointTreeNode.newInstance();
            double[] dArray3 = new double[dArray2.length];
            for (Object object2 : objectArray) {
                this.insert(pointTreeNode2, dArray, object2, dArray3);
            }
            pointTreeNode.setChild(n, pointTreeNode2);
            pointTreeNode = pointTreeNode2;
        }
    }

    @Override
    public boolean contains(Object object) {
        int n;
        Object object2;
        if (!this.elementType.isInstance(object)) {
            return false;
        }
        PointTreeNode pointTreeNode = this.root;
        double[] dArray = (double[])this.treeRegion.clone();
        double[] dArray2 = new double[this.getDimension()];
        this.locator.getPositionOf(object, dArray2);
        while ((object2 = pointTreeNode.getChild(n = PointTreeNode.quadrant(dArray2, dArray))) != null) {
            if (object2 instanceof PointTreeNode) {
                PointTreeNode.enterQuadrant(dArray, n);
                pointTreeNode = (PointTreeNode)object2;
                continue;
            }
            for (Object object3 : (Object[])object2) {
                if (!object.equals(object3)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return Spliterators.iterator(this.spliterator());
    }

    @Override
    public Spliterator<E> spliterator() {
        return new NodeIterator<E>(this, null){

            @Override
            public long estimateSize() {
                return PointTree.this.count;
            }

            @Override
            public int characteristics() {
                return 321;
            }

            @Override
            protected boolean filter(E e) {
                return true;
            }
        };
    }

    @Override
    public Stream<E> parallelStream() {
        return StreamSupport.stream(this.spliterator(), this.parallel);
    }

    public Stream<E> queryByBoundingBox(Envelope envelope) {
        ArgumentChecks.ensureNonNull("searchRegion", envelope);
        ArgumentChecks.ensureDimensionMatches("searchRegion", this.getDimension(), envelope);
        return StreamSupport.stream(new NodeIterator(this, envelope), this.parallel);
    }

    @FunctionalInterface
    public static interface Locator<E> {
        public void getPositionOf(E var1, double[] var2);
    }
}

