/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.j2d;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.sis.internal.referencing.j2d.AffineTransform2D;
import org.apache.sis.internal.referencing.j2d.ImmutableAffineTransform;
import org.apache.sis.internal.referencing.j2d.Tile;
import org.apache.sis.referencing.operation.matrix.AffineTransforms2D;

public class TileOrganizer {
    private static final double EPS = 1.0E-10;
    private final int xLocation;
    private final int yLocation;
    private final Map<AffineTransform, Tile> tiles;
    private static final Comparator<AffineTransform> X_COMPARATOR = new Comparator<AffineTransform>(){

        @Override
        public int compare(AffineTransform affineTransform, AffineTransform affineTransform2) {
            return Double.compare(AffineTransforms2D.getScaleX0(affineTransform), AffineTransforms2D.getScaleX0(affineTransform2));
        }
    };
    private static final Comparator<AffineTransform> Y_COMPARATOR = new Comparator<AffineTransform>(){

        @Override
        public int compare(AffineTransform affineTransform, AffineTransform affineTransform2) {
            return Double.compare(AffineTransforms2D.getScaleY0(affineTransform), AffineTransforms2D.getScaleY0(affineTransform2));
        }
    };

    public TileOrganizer(Point point) {
        if (point != null) {
            this.xLocation = point.x;
            this.yLocation = point.y;
        } else {
            this.yLocation = 0;
            this.xLocation = 0;
        }
        this.tiles = new IdentityHashMap<AffineTransform, Tile>();
    }

    public Point getLocation() {
        return new Point(this.xLocation, this.yLocation);
    }

    public boolean add(Tile tile) {
        AffineTransform affineTransform = tile.getPendingGridToCRS();
        if (affineTransform == null) {
            return false;
        }
        if (this.tiles.putIfAbsent(affineTransform, tile) != null) {
            throw new IllegalStateException();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Map<Tile, Tile[]> tiles() throws IOException {
        HashMap<Tile, Tile[]> hashMap = new HashMap<Tile, Tile[]>(4);
        Iterator<Map<AffineTransform, Dimension>> iterator = TileOrganizer.computePyramidLevels(this.tiles.keySet()).iterator();
        while (iterator.hasNext()) {
            Cloneable cloneable;
            Object object;
            Map<AffineTransform, Dimension> map = iterator.next();
            AffineTransform affineTransform = null;
            double d = Double.POSITIVE_INFINITY;
            double d2 = Double.POSITIVE_INFINITY;
            double d3 = Double.POSITIVE_INFINITY;
            double d4 = Double.POSITIVE_INFINITY;
            for (AffineTransform affineTransform2 : map.keySet()) {
                double d5 = AffineTransforms2D.getScale(affineTransform2);
                double d6 = affineTransform2.getTranslateY();
                if (affineTransform2.getScaleY() < 0.0 || affineTransform2.getShearY() < 0.0) {
                    d6 = -d6;
                }
                double d7 = affineTransform2.getTranslateX();
                if (affineTransform2.getScaleX() < 0.0 || affineTransform2.getShearX() < 0.0) {
                    d7 = -d7;
                }
                if (!(Math.abs(d5 - d4) <= 1.0E-10)) {
                    if (!(d5 < d4)) continue;
                    d4 = d5;
                    d3 = d6;
                    d = d7;
                } else {
                    if (d7 < d) {
                        d = d7;
                    }
                    if (!(Math.abs(d6 - d3) <= 1.0E-10)) {
                        if (!(d6 < d3)) continue;
                        d3 = d6;
                    } else if (!(d7 < d2)) continue;
                }
                d2 = d7;
                affineTransform = affineTransform2;
            }
            if (affineTransform == null) continue;
            if ((d2 -= d) > 1.0E-10) {
                object = new double[6];
                affineTransform.getMatrix((double[])object);
                object[4] = d;
                affineTransform = new AffineTransform((double[])object);
            } else {
                affineTransform = new AffineTransform(affineTransform);
            }
            try {
                object = affineTransform.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new IllegalStateException(noninvertibleTransformException);
            }
            int n = 0;
            Rectangle rectangle = null;
            Rectangle2D.Double double_ = new Rectangle2D.Double();
            Tile[] tileArray = new Tile[map.size()];
            for (Map.Entry<AffineTransform, Dimension> entry : map.entrySet()) {
                Rectangle rectangle2;
                cloneable = entry.getKey();
                Tile[] tileArray2 = this.tiles.remove(cloneable);
                ((AffineTransform)cloneable).preConcatenate((AffineTransform)object);
                Tile[] tileArray3 = tileArray2;
                // MONITORENTER : tileArray2
                tileArray2.setSubsampling(entry.getValue());
                try {
                    rectangle2 = tileArray2.getRegion();
                }
                catch (IOException iOException) {
                    if (!this.unavailableSize((Tile)tileArray2, iOException)) {
                        throw iOException;
                    }
                    rectangle2 = null;
                }
                if (rectangle2 != null) {
                    AffineTransforms2D.transform((AffineTransform)cloneable, rectangle2, double_);
                    rectangle2.x = Math.toIntExact(Math.round(double_.x));
                    rectangle2.y = Math.toIntExact(Math.round(double_.y));
                    rectangle2.width = Math.toIntExact(Math.round(double_.width));
                    rectangle2.height = Math.toIntExact(Math.round(double_.height));
                } else {
                    Point point = tileArray2.getLocation();
                    ((AffineTransform)cloneable).transform(point, point);
                    rectangle2 = new Rectangle(point.x, point.y, 0, 0);
                }
                tileArray2.setRegionOnFinestLevel(rectangle2);
                // MONITOREXIT : tileArray3
                if (rectangle == null) {
                    rectangle = rectangle2;
                } else {
                    rectangle.add(rectangle2);
                }
                tileArray[n++] = tileArray2;
            }
            map.clear();
            if (rectangle == null) continue;
            int n2 = this.xLocation - rectangle.x;
            int n3 = this.yLocation - rectangle.y;
            if ((n2 | n3) != 0) {
                affineTransform.translate(-n2, -n3);
                rectangle.translate(n2, n3);
            }
            affineTransform = new AffineTransform2D(affineTransform);
            cloneable = new HashMap();
            for (Tile tile : tileArray) {
                Dimension dimension = tile.getSubsampling();
                Translation translation = (Translation)cloneable.get(dimension);
                if (translation == null) {
                    translation = new Translation(dimension, affineTransform, n2, n3);
                    cloneable.put(dimension, translation);
                }
                translation.applyTo(tile);
            }
            hashMap.put(new Tile(affineTransform, rectangle), tileArray);
        }
        return hashMap;
    }

    private static List<Map<AffineTransform, Dimension>> computePyramidLevels(Collection<AffineTransform> collection) {
        IdentityHashMap identityHashMap;
        ArrayList<Map<AffineTransform, Dimension>> arrayList = new ArrayList<Map<AffineTransform, Dimension>>(2);
        AffineTransform[] affineTransformArray = collection.toArray(new AffineTransform[collection.size()]);
        Arrays.sort(affineTransformArray, X_COMPARATOR);
        int n = affineTransformArray.length;
        while (n != 0) {
            identityHashMap = new IdentityHashMap();
            if (n <= (n = TileOrganizer.computePyramidLevels(affineTransformArray, n, identityHashMap, false))) {
                throw new AssertionError(n);
            }
            arrayList.add(identityHashMap);
        }
        identityHashMap = arrayList.iterator();
        while (identityHashMap.hasNext()) {
            Map map = (Map)identityHashMap.next();
            n = map.size();
            affineTransformArray = map.keySet().toArray(affineTransformArray);
            Arrays.sort(affineTransformArray, 0, n, Y_COMPARATOR);
            n = TileOrganizer.computePyramidLevels(affineTransformArray, n, map, true);
            while (--n >= 0) {
                if (map.remove(affineTransformArray[n]) == null) {
                    throw new AssertionError(n);
                }
            }
            if (!map.isEmpty()) continue;
            identityHashMap.remove();
        }
        return arrayList;
    }

    private static int computePyramidLevels(AffineTransform[] affineTransformArray, int n, Map<AffineTransform, Dimension> map, boolean bl) {
        boolean bl2;
        boolean bl3;
        double d;
        double d2;
        AffineTransform affineTransform;
        int n2 = 0;
        int n3 = 0;
        while (true) {
            if (n2 >= n) {
                return n3;
            }
            affineTransform = affineTransformArray[n2++];
            if (bl) {
                d2 = affineTransform.getScaleY();
                d = affineTransform.getShearY();
            } else {
                d2 = affineTransform.getScaleX();
                d = affineTransform.getShearX();
            }
            bl3 = Math.abs(d2) < 1.0E-10;
            boolean bl4 = bl2 = Math.abs(d) < 1.0E-10;
            if (!(bl3 & bl2)) break;
            map.remove(affineTransform);
        }
        if (bl) {
            map.get((Object)affineTransform).height = 1;
        } else {
            assert (map.isEmpty()) : map;
            map.put(affineTransform, new Dimension(1, 0));
        }
        while (n2 < n) {
            int n4;
            double d3;
            double d4;
            AffineTransform affineTransform2 = affineTransformArray[n2++];
            if (bl) {
                d4 = affineTransform2.getScaleY();
                d3 = affineTransform2.getShearY();
            } else {
                d4 = affineTransform2.getScaleX();
                d3 = affineTransform2.getShearX();
            }
            if (bl3) {
                if (!(Math.abs(d4) < 1.0E-10)) {
                    affineTransformArray[n3++] = affineTransform2;
                    continue;
                }
                n4 = TileOrganizer.level(d3 / d);
            } else {
                n4 = TileOrganizer.level(d4 / d2);
                if (bl2 ? !(Math.abs(d3) < 1.0E-10) : TileOrganizer.level(d3 / d) != n4) {
                    affineTransformArray[n3++] = affineTransform2;
                    continue;
                }
            }
            if (n4 == 0) {
                affineTransformArray[n3++] = affineTransform2;
                continue;
            }
            if (bl) {
                map.get((Object)affineTransform2).height = n4;
                continue;
            }
            if (map.put(affineTransform2, new Dimension(n4, 0)) != null) {
                throw new AssertionError(affineTransform2);
            }
        }
        Arrays.fill(affineTransformArray, n3, n, null);
        return n3;
    }

    private static int level(double d) {
        if (d > 0.0 && d < Double.POSITIVE_INFINITY) {
            double d2;
            boolean bl;
            boolean bl2 = bl = d < 0.75;
            if (bl) {
                d = 1.0 / d;
            }
            if ((d2 = Math.rint(d)) < 2.147483647E9 && Math.abs(d - d2) < 1.0E-10) {
                int n = (int)d2;
                if (bl) {
                    n = -n;
                }
                return n;
            }
        }
        return 0;
    }

    protected boolean unavailableSize(Tile tile, IOException iOException) {
        return false;
    }

    public String toString() {
        return Tile.toString(this.tiles.values(), 400);
    }

    private static final class Translation {
        private final AffineTransform gridToCRS;
        private final int dx;
        private final int dy;

        Translation(Dimension dimension, AffineTransform affineTransform, int n, int n2) {
            this.dx = n / dimension.width;
            this.dy = n2 / dimension.height;
            affineTransform = new AffineTransform(affineTransform);
            affineTransform.scale(dimension.width, dimension.height);
            affineTransform.translate(n %= dimension.width, n2 %= dimension.height);
            this.gridToCRS = new ImmutableAffineTransform(affineTransform);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void applyTo(Tile tile) {
            Tile tile2 = tile;
            synchronized (tile2) {
                tile.translate(this.dx, this.dy);
                tile.setGridToCRS(this.gridToCRS);
            }
        }
    }
}

