/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.events.model;

import java.util.Stack;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.events.model.EventMethodModel;
import org.apache.fop.events.model.EventModel;
import org.apache.fop.events.model.EventProducerModel;
import org.apache.fop.events.model.EventSeverity;
import org.apache.fop.util.DefaultErrorListener;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EventModelParser {
    protected static Log log = LogFactory.getLog((Class)EventModelParser.class);
    private static SAXTransformerFactory tFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();

    public static EventModel parse(Source src) throws TransformerException {
        Transformer transformer = tFactory.newTransformer();
        transformer.setErrorListener(new DefaultErrorListener(log));
        EventModel model = new EventModel();
        SAXResult res = new SAXResult(EventModelParser.getContentHandler(model));
        transformer.transform(src, res);
        return model;
    }

    public static ContentHandler getContentHandler(EventModel model) {
        return new Handler(model);
    }

    private static class Handler
    extends DefaultHandler {
        private EventModel model;
        private Stack objectStack = new Stack();

        public Handler(EventModel model) {
            this.model = model;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            block10: {
                try {
                    if ("event-model".equals(localName)) {
                        if (this.objectStack.size() > 0) {
                            throw new SAXException("event-model must be the root element");
                        }
                        this.objectStack.push(this.model);
                        break block10;
                    }
                    if ("producer".equals(localName)) {
                        EventProducerModel producer = new EventProducerModel(attributes.getValue("name"));
                        EventModel parent = (EventModel)this.objectStack.peek();
                        parent.addProducer(producer);
                        this.objectStack.push(producer);
                        break block10;
                    }
                    if ("method".equals(localName)) {
                        EventSeverity severity = EventSeverity.valueOf(attributes.getValue("severity"));
                        String ex = attributes.getValue("exception");
                        EventMethodModel method = new EventMethodModel(attributes.getValue("name"), severity);
                        if (ex != null && ex.length() > 0) {
                            method.setExceptionClass(ex);
                        }
                        EventProducerModel parent = (EventProducerModel)this.objectStack.peek();
                        parent.addMethod(method);
                        this.objectStack.push(method);
                        break block10;
                    }
                    if ("parameter".equals(localName)) {
                        Class<?> type;
                        String className = attributes.getValue("type");
                        try {
                            type = Class.forName(className);
                        }
                        catch (ClassNotFoundException e) {
                            throw new SAXException("Could not find Class for: " + className, e);
                        }
                        String name = attributes.getValue("name");
                        EventMethodModel parent = (EventMethodModel)this.objectStack.peek();
                        this.objectStack.push(parent.addParameter(type, name));
                        break block10;
                    }
                    throw new SAXException("Invalid element: " + qName);
                }
                catch (ClassCastException cce) {
                    throw new SAXException("XML format error: " + qName, cce);
                }
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.objectStack.pop();
        }
    }
}

