/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pdf;

import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pdfbox.contentstream.PDFGraphicsStreamEngine;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.filter.MissingImageReaderException;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.color.PDPattern;
import org.apache.pdfbox.pdmodel.graphics.form.PDTransparencyGroup;
import org.apache.pdfbox.pdmodel.graphics.image.PDImage;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDAbstractPattern;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDTilingPattern;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.pdmodel.graphics.state.PDSoftMask;
import org.apache.pdfbox.pdmodel.graphics.state.RenderingMode;
import org.apache.pdfbox.tools.imageio.ImageIOUtil;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.Vector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.exception.TikaMemoryLimitException;
import org.apache.tika.exception.ZeroByteFileException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.BoundedInputStream;
import org.apache.tika.io.IOExceptionWithCause;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.pdf.PDFParserConfig;
import org.apache.tika.parser.pdf.PDMetadataExtractor;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class ImageGraphicsEngine
extends PDFGraphicsStreamEngine {
    private static final long MAX_IMAGE_LENGTH_BYTES = 0x6400000L;
    private static final List<String> JPEG = Arrays.asList(COSName.DCT_DECODE.getName(), COSName.DCT_DECODE_ABBREVIATION.getName());
    private static final List<String> JP2 = Arrays.asList(COSName.JPX_DECODE.getName());
    private static final List<String> JB2 = Arrays.asList(COSName.JBIG2_DECODE.getName());
    private boolean useDirectJPEG = false;
    final List<IOException> exceptions = new ArrayList<IOException>();
    private final EmbeddedDocumentExtractor embeddedDocumentExtractor;
    private final PDFParserConfig pdfParserConfig;
    private final Map<COSStream, Integer> processedInlineImages;
    private final AtomicInteger imageCounter;
    private final Metadata parentMetadata;
    private final XHTMLContentHandler xhtml;
    private final ParseContext parseContext;
    private final boolean extractInlineImageMetadataOnly;

    protected ImageGraphicsEngine(PDPage page, EmbeddedDocumentExtractor embeddedDocumentExtractor, PDFParserConfig pdfParserConfig, Map<COSStream, Integer> processedInlineImages, AtomicInteger imageCounter, XHTMLContentHandler xhtml, Metadata parentMetadata, ParseContext parseContext) {
        super(page);
        this.embeddedDocumentExtractor = embeddedDocumentExtractor;
        this.pdfParserConfig = pdfParserConfig;
        this.processedInlineImages = processedInlineImages;
        this.imageCounter = imageCounter;
        this.xhtml = xhtml;
        this.parentMetadata = parentMetadata;
        this.parseContext = parseContext;
        this.extractInlineImageMetadataOnly = pdfParserConfig.getExtractInlineImageMetadataOnly();
    }

    void run() throws IOException {
        PDPage page = this.getPage();
        this.processPage(page);
        PDResources res = page.getResources();
        if (res == null) {
            return;
        }
        for (COSName name : res.getExtGStateNames()) {
            PDSoftMask softMask;
            PDExtendedGraphicsState extendedGraphicsState = res.getExtGState(name);
            if (extendedGraphicsState == null || (softMask = extendedGraphicsState.getSoftMask()) == null) continue;
            try {
                PDTransparencyGroup group = softMask.getGroup();
                if (group == null) continue;
                res.getExtGState(name).copyIntoGraphicsState(this.getGraphicsState());
                this.processSoftMask(group);
            }
            catch (IOException e) {
                this.handleCatchableIOE(e);
            }
        }
    }

    public void drawImage(PDImage pdImage) throws IOException {
        int imageNumber = 0;
        if (pdImage instanceof PDImageXObject) {
            PDImageXObject xobject;
            Integer cachedNumber;
            if (pdImage.isStencil()) {
                this.processColor(this.getGraphicsState().getNonStrokingColor());
            }
            if ((cachedNumber = this.processedInlineImages.get((xobject = (PDImageXObject)pdImage).getCOSObject())) != null && this.pdfParserConfig.getExtractUniqueInlineImagesOnly()) {
                return;
            }
            if (cachedNumber == null) {
                imageNumber = this.imageCounter.getAndIncrement();
                this.processedInlineImages.put(xobject.getCOSObject(), imageNumber);
            }
        } else {
            imageNumber = this.imageCounter.getAndIncrement();
        }
        try {
            this.processImage(pdImage, imageNumber);
        }
        catch (TikaException | SAXException e) {
            throw new IOExceptionWithCause(e);
        }
        catch (IOException e) {
            this.handleCatchableIOE(e);
        }
    }

    public void appendRectangle(Point2D p0, Point2D p1, Point2D p2, Point2D p3) throws IOException {
    }

    public void clip(int windingRule) throws IOException {
    }

    public void moveTo(float x, float y) throws IOException {
    }

    public void lineTo(float x, float y) throws IOException {
    }

    public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) throws IOException {
    }

    public Point2D getCurrentPoint() throws IOException {
        return new Point2D.Float(0.0f, 0.0f);
    }

    public void closePath() throws IOException {
    }

    public void endPath() throws IOException {
    }

    protected void showGlyph(Matrix textRenderingMatrix, PDFont font, int code, String unicode, Vector displacement) throws IOException {
        RenderingMode renderingMode = this.getGraphicsState().getTextState().getRenderingMode();
        if (renderingMode.isFill()) {
            this.processColor(this.getGraphicsState().getNonStrokingColor());
        }
        if (renderingMode.isStroke()) {
            this.processColor(this.getGraphicsState().getStrokingColor());
        }
    }

    public void strokePath() throws IOException {
        this.processColor(this.getGraphicsState().getStrokingColor());
    }

    public void fillPath(int windingRule) throws IOException {
        this.processColor(this.getGraphicsState().getNonStrokingColor());
    }

    public void fillAndStrokePath(int windingRule) throws IOException {
        this.processColor(this.getGraphicsState().getNonStrokingColor());
    }

    public void shadingFill(COSName shadingName) throws IOException {
    }

    private void processColor(PDColor color) throws IOException {
        PDPattern pattern;
        PDAbstractPattern abstractPattern;
        if (color.getColorSpace() instanceof PDPattern && (abstractPattern = (pattern = (PDPattern)color.getColorSpace()).getPattern(color)) instanceof PDTilingPattern) {
            this.processTilingPattern((PDTilingPattern)abstractPattern, null, null);
        }
    }

    private void processImage(PDImage pdImage, int imageNumber) throws IOException, TikaException, SAXException {
        Metadata metadata = new Metadata();
        String suffix = this.getSuffix(pdImage, metadata);
        String fileName = "image" + imageNumber + "." + suffix;
        AttributesImpl attr = new AttributesImpl();
        attr.addAttribute("", "src", "src", "CDATA", "embedded:" + fileName);
        attr.addAttribute("", "alt", "alt", "CDATA", fileName);
        this.xhtml.startElement("img", attr);
        this.xhtml.endElement("img");
        metadata.set("resourceName", fileName);
        metadata.set(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE, TikaCoreProperties.EmbeddedResourceType.INLINE.toString());
        if (this.extractInlineImageMetadataOnly) {
            this.extractInlineImageMetadataOnly(pdImage, metadata);
            return;
        }
        if (this.embeddedDocumentExtractor.shouldParseEmbedded(metadata)) {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            if (pdImage instanceof PDImageXObject) {
                PDMetadataExtractor.extract(((PDImageXObject)pdImage).getMetadata(), metadata, this.parseContext);
            }
            try {
                ImageGraphicsEngine.writeToBuffer(pdImage, suffix, this.useDirectJPEG, buffer);
            }
            catch (MissingImageReaderException e) {
                EmbeddedDocumentUtil.recordException((Throwable)e, (Metadata)this.parentMetadata);
                return;
            }
            catch (IOException e) {
                EmbeddedDocumentUtil.recordEmbeddedStreamException((Throwable)e, (Metadata)metadata);
                return;
            }
            try (TikaInputStream embeddedIs = TikaInputStream.get((byte[])buffer.toByteArray());){
                this.embeddedDocumentExtractor.parseEmbedded((InputStream)embeddedIs, (ContentHandler)new EmbeddedContentHandler((ContentHandler)this.xhtml), metadata, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractInlineImageMetadataOnly(PDImage pdImage, Metadata metadata) throws IOException, SAXException {
        if (pdImage instanceof PDImageXObject) {
            PDMetadataExtractor.extract(((PDImageXObject)pdImage).getMetadata(), metadata, this.parseContext);
        }
        metadata.set(Metadata.IMAGE_WIDTH, pdImage.getWidth());
        metadata.set(Metadata.IMAGE_LENGTH, pdImage.getHeight());
        ZeroByteFileException.IgnoreZeroByteFileException before = (ZeroByteFileException.IgnoreZeroByteFileException)this.parseContext.get(ZeroByteFileException.IgnoreZeroByteFileException.class);
        try {
            this.parseContext.set(ZeroByteFileException.IgnoreZeroByteFileException.class, (Object)ZeroByteFileException.IGNORE_ZERO_BYTE_FILE_EXCEPTION);
            this.embeddedDocumentExtractor.parseEmbedded((InputStream)TikaInputStream.get((byte[])new byte[0]), (ContentHandler)new EmbeddedContentHandler((ContentHandler)this.xhtml), metadata, false);
        }
        finally {
            this.parseContext.set(ZeroByteFileException.IgnoreZeroByteFileException.class, (Object)before);
        }
    }

    private String getSuffix(PDImage pdImage, Metadata metadata) throws IOException {
        String suffix = pdImage.getSuffix();
        if (suffix == null || suffix.equals("png")) {
            metadata.set("Content-Type", "image/png");
            suffix = "png";
        } else if (suffix.equals("jpg")) {
            metadata.set("Content-Type", "image/jpeg");
        } else if (suffix.equals("tiff")) {
            metadata.set("Content-Type", "image/tiff");
            suffix = "tif";
        } else if (suffix.equals("jpx")) {
            metadata.set("Content-Type", "image/jp2");
            suffix = "jp2";
        } else if (suffix.equals("jb2")) {
            metadata.set("Content-Type", "image/x-jbig2");
        }
        if (ImageGraphicsEngine.hasMasks(pdImage)) {
            suffix = "png";
        }
        return suffix;
    }

    void handleCatchableIOE(IOException e) throws IOException {
        String msg;
        if (this.pdfParserConfig.getCatchIntermediateIOExceptions()) {
            if (e.getCause() instanceof SAXException && e.getCause().getMessage() != null && e.getCause().getMessage().contains("Your document contained more than")) {
                throw e;
            }
            msg = e.getMessage();
            if (msg == null) {
                msg = "IOException, no message";
            }
        } else {
            throw e;
        }
        this.parentMetadata.add(TikaCoreProperties.TIKA_META_EXCEPTION_WARNING, msg);
        this.exceptions.add(e);
    }

    List<IOException> getExceptions() {
        return this.exceptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToBuffer(PDImage pdImage, String suffix, boolean directJPEG, OutputStream out) throws IOException, TikaException {
        if ("jpg".equals(suffix)) {
            String colorSpaceName = pdImage.getColorSpace().getName();
            if (directJPEG || PDDeviceGray.INSTANCE.getName().equals(colorSpaceName) || PDDeviceRGB.INSTANCE.getName().equals(colorSpaceName)) {
                InputStream data = pdImage.createInputStream(JPEG);
                try {
                    ImageGraphicsEngine.copyUpToMaxLength(data, out);
                }
                finally {
                    IOUtils.closeQuietly((Closeable)data);
                }
            } else {
                BufferedImage image = pdImage.getImage();
                if (image != null) {
                    ImageIOUtil.writeImage((BufferedImage)image, (String)suffix, (OutputStream)out);
                }
            }
        } else if ("jp2".equals(suffix)) {
            String colorSpaceName = pdImage.getColorSpace().getName();
            if (directJPEG || !ImageGraphicsEngine.hasMasks(pdImage) && (PDDeviceGray.INSTANCE.getName().equals(colorSpaceName) || PDDeviceRGB.INSTANCE.getName().equals(colorSpaceName))) {
                InputStream data = pdImage.createInputStream(JP2);
                try {
                    ImageGraphicsEngine.copyUpToMaxLength(data, out);
                }
                finally {
                    IOUtils.closeQuietly((Closeable)data);
                }
            } else {
                BufferedImage image = pdImage.getImage();
                if (image != null) {
                    ImageIOUtil.writeImage((BufferedImage)image, (String)"jpeg2000", (OutputStream)out);
                }
            }
        } else if ("tif".equals(suffix) && pdImage.getColorSpace().equals(PDDeviceGray.INSTANCE)) {
            BufferedImage image = pdImage.getImage();
            if (image == null) {
                return;
            }
            int w = image.getWidth();
            int h = image.getHeight();
            BufferedImage bitonalImage = new BufferedImage(w, h, 12);
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    bitonalImage.setRGB(x, y, image.getRGB(x, y));
                }
            }
            ImageIOUtil.writeImage((BufferedImage)bitonalImage, (String)suffix, (OutputStream)out);
        } else if ("jb2".equals(suffix)) {
            InputStream data = pdImage.createInputStream(JB2);
            try {
                ImageGraphicsEngine.copyUpToMaxLength(data, out);
            }
            finally {
                IOUtils.closeQuietly((Closeable)data);
            }
        } else {
            BufferedImage image = pdImage.getImage();
            if (image == null) {
                return;
            }
            ImageIOUtil.writeImage((BufferedImage)image, (String)suffix, (OutputStream)out);
        }
        out.flush();
    }

    private static void copyUpToMaxLength(InputStream is, OutputStream os) throws IOException, TikaException {
        BoundedInputStream bis = new BoundedInputStream(0x6400000L, is);
        IOUtils.copy((InputStream)bis, (OutputStream)os);
        if (bis.hasHitBound()) {
            throw new TikaMemoryLimitException("Image size is larger than allowed (104857600)");
        }
    }

    private static boolean hasMasks(PDImage pdImage) throws IOException {
        if (pdImage instanceof PDImageXObject) {
            PDImageXObject ximg = (PDImageXObject)pdImage;
            return ximg.getMask() != null || ximg.getSoftMask() != null;
        }
        return false;
    }
}

