/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.common.params.SolrParams;

public class DelegationTokenHttpSolrClient
extends HttpSolrClient {
    public static final String DELEGATION_TOKEN_PARAM = "delegation";

    protected DelegationTokenHttpSolrClient(HttpSolrClient.Builder builder) {
        super(builder);
        this.setQueryParams(new TreeSet<String>(Arrays.asList(DELEGATION_TOKEN_PARAM)));
    }

    @Override
    protected HttpRequestBase createMethod(SolrRequest<?> request, String collection) throws IOException, SolrServerException {
        SolrParams params = request.getParams();
        if (params != null && params.getParams(DELEGATION_TOKEN_PARAM) != null) {
            throw new IllegalArgumentException("delegation parameter not supported");
        }
        return super.createMethod(request, collection);
    }

    @Override
    public void setQueryParams(Set<String> queryParams) {
        Set<String> set = queryParams = queryParams == null ? Set.of(DELEGATION_TOKEN_PARAM) : queryParams;
        if (!queryParams.contains(DELEGATION_TOKEN_PARAM)) {
            queryParams = new HashSet<String>(queryParams);
            queryParams.add(DELEGATION_TOKEN_PARAM);
            queryParams = Collections.unmodifiableSet(queryParams);
        }
        super.setQueryParams(queryParams);
    }
}

