/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.http.QueryParameter;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Urls {
    public static Map<String, QueryParameter> splitQuery(String query) {
        if (query == null) {
            return Collections.emptyMap();
        }
        Iterable pairs = Splitter.on((char)'&').split((CharSequence)query);
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (String queryElement : pairs) {
            int firstEqualsIndex = queryElement.indexOf(61);
            if (firstEqualsIndex == -1) {
                builder.putAll((Object)queryElement, (Object[])new String[]{""});
                continue;
            }
            String key = queryElement.substring(0, firstEqualsIndex);
            String value = Urls.decode(queryElement.substring(firstEqualsIndex + 1));
            builder.putAll((Object)key, (Object[])new String[]{value});
        }
        return Maps.transformEntries((Map)builder.build().asMap(), (Maps.EntryTransformer)new Maps.EntryTransformer<String, Collection<String>, QueryParameter>(){

            public QueryParameter transformEntry(String key, Collection<String> values) {
                return new QueryParameter(key, (List<String>)ImmutableList.copyOf(values));
            }
        });
    }

    public static Map<String, QueryParameter> splitQuery(URI uri) {
        if (uri == null) {
            return Collections.emptyMap();
        }
        return Urls.splitQuery(uri.getRawQuery());
    }

    public static String decode(String encoded) {
        try {
            return URLDecoder.decode(encoded, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return Exceptions.throwUnchecked(e, String.class);
        }
    }
}

