/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.util.ArrayList;
import org.apache.uima.internal.util.StringUtils;

public class CharacterUtils {
    private static final boolean isType(char c, int[] types) {
        int charType = Character.getType(c);
        int max = types.length;
        for (int i = 0; i < max; ++i) {
            if (charType != types[i]) continue;
            return true;
        }
        return false;
    }

    private static ArrayList<CharRange> getCharacterRanges(int[] charSpecs) {
        ArrayList<CharRange> ranges = new ArrayList<CharRange>();
        for (char c = '\u0000'; c <= '\uffff'; c = (char)(c + '\u0001')) {
            if (CharacterUtils.isType(c, charSpecs)) {
                CharRange range = new CharRange();
                range.start = c;
                range.end = c;
                if (c == '\uffff') break;
                for (c = (char)(c + '\u0001'); c <= '\uffff' && CharacterUtils.isType(c, charSpecs); c = (char)(c + '\u0001')) {
                    range.end = c;
                    if (c == '\uffff') break;
                }
                ranges.add(range);
            }
            if (c == '\uffff') break;
        }
        return ranges;
    }

    public static String toUnicodeChar(char c) {
        String prefix = "\\u";
        String code = Integer.toHexString(c);
        switch (code.length()) {
            case 1: {
                return prefix + "000" + code;
            }
            case 2: {
                return prefix + "00" + code;
            }
            case 3: {
                return prefix + "0" + code;
            }
        }
        return prefix + code;
    }

    public static String toHexString(char c) {
        String prefix = "0x";
        String code = Integer.toHexString(c);
        switch (code.length()) {
            case 1: {
                return prefix + "000" + code;
            }
            case 2: {
                return prefix + "00" + code;
            }
            case 3: {
                return prefix + "0" + code;
            }
        }
        return prefix + code;
    }

    public static ArrayList<CharRange> getLetterRange() {
        int[] types = new int[]{1, 2, 3, 4, 5};
        return CharacterUtils.getCharacterRanges(types);
    }

    public static ArrayList<CharRange> getDigitRange() {
        int[] types = new int[]{9};
        return CharacterUtils.getCharacterRanges(types);
    }

    public static void printAntlrLexRule(String name, ArrayList<CharRange> charRanges) {
        System.out.print(name + " : ");
        StringBuffer spaceBuffer = new StringBuffer();
        StringUtils.printSpaces(name.length(), spaceBuffer);
        String spaces = spaceBuffer.toString();
        for (int i = 0; i < charRanges.size(); ++i) {
            CharRange range;
            if (i != 0) {
                System.out.print("\n" + spaces + " | ");
            }
            if ((range = charRanges.get(i)).start == range.end) {
                System.out.print(" '" + CharacterUtils.toUnicodeChar(range.start) + "'");
                continue;
            }
            System.out.print(" '" + CharacterUtils.toUnicodeChar(range.start) + "' .. '" + CharacterUtils.toUnicodeChar(range.end) + "' ");
        }
        System.out.println("\n" + spaces + " ;");
    }

    public static void printJavaCCLexRule(String name, ArrayList<CharRange> charRanges) {
        System.out.print(name + " = ");
        StringBuffer spaceBuffer = new StringBuffer();
        StringUtils.printSpaces(name.length(), spaceBuffer);
        String spaces = spaceBuffer.toString();
        for (int i = 0; i < charRanges.size(); ++i) {
            CharRange range;
            if (i != 0) {
                System.out.print("\n" + spaces + " | ");
            }
            if ((range = charRanges.get(i)).start == range.end) {
                System.out.print(CharacterUtils.toHexString(range.start));
                continue;
            }
            System.out.print("[" + CharacterUtils.toHexString(range.start) + ".." + CharacterUtils.toHexString(range.end) + "]");
        }
        System.out.println("\n" + spaces + " ;");
    }

    public static void main(String[] args) {
        ArrayList<CharRange> letters = CharacterUtils.getDigitRange();
        CharacterUtils.printJavaCCLexRule("udigit", letters);
    }

    private static class CharRange {
        private char start;
        private char end;

        private CharRange() {
        }
    }
}

