/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.components.dialog.documents;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.luke.app.IndexHandler;
import org.apache.lucene.luke.app.IndexObserver;
import org.apache.lucene.luke.app.LukeState;
import org.apache.lucene.luke.app.desktop.Preferences;
import org.apache.lucene.luke.app.desktop.PreferencesFactory;
import org.apache.lucene.luke.app.desktop.components.AnalysisTabOperator;
import org.apache.lucene.luke.app.desktop.components.ComponentOperatorRegistry;
import org.apache.lucene.luke.app.desktop.components.DocumentsTabOperator;
import org.apache.lucene.luke.app.desktop.components.TabSwitcherProxy;
import org.apache.lucene.luke.app.desktop.components.TabbedPaneProvider;
import org.apache.lucene.luke.app.desktop.components.TableColumnInfo;
import org.apache.lucene.luke.app.desktop.components.TableModelBase;
import org.apache.lucene.luke.app.desktop.components.dialog.HelpDialogFactory;
import org.apache.lucene.luke.app.desktop.components.dialog.documents.AddDocumentDialogOperator;
import org.apache.lucene.luke.app.desktop.components.dialog.documents.IndexOptionsDialogFactory;
import org.apache.lucene.luke.app.desktop.dto.documents.NewField;
import org.apache.lucene.luke.app.desktop.util.DialogOpener;
import org.apache.lucene.luke.app.desktop.util.FontUtils;
import org.apache.lucene.luke.app.desktop.util.HelpHeaderRenderer;
import org.apache.lucene.luke.app.desktop.util.MessageUtils;
import org.apache.lucene.luke.app.desktop.util.NumericUtils;
import org.apache.lucene.luke.app.desktop.util.StringUtils;
import org.apache.lucene.luke.app.desktop.util.TableUtils;
import org.apache.lucene.luke.models.LukeException;
import org.apache.lucene.luke.models.tools.IndexTools;
import org.apache.lucene.luke.models.tools.IndexToolsFactory;
import org.apache.lucene.luke.util.LoggerFactory;
import org.apache.lucene.util.BytesRef;

public final class AddDocumentDialogFactory
implements DialogOpener.DialogFactory,
AddDocumentDialogOperator {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static AddDocumentDialogFactory instance;
    private static final int ROW_COUNT = 50;
    private final Preferences prefs;
    private final IndexHandler indexHandler;
    private final IndexToolsFactory toolsFactory = new IndexToolsFactory();
    private final TabSwitcherProxy tabSwitcher;
    private final ComponentOperatorRegistry operatorRegistry;
    private final IndexOptionsDialogFactory indexOptionsDialogFactory;
    private final HelpDialogFactory helpDialogFactory;
    private final ListenerFunctions listeners = new ListenerFunctions();
    private final JLabel analyzerNameLbl = new JLabel(StandardAnalyzer.class.getName());
    private final List<NewField> newFieldList;
    private final JButton addBtn = new JButton();
    private final JButton closeBtn = new JButton();
    private final JTextArea infoTA = new JTextArea();
    private IndexTools toolsModel;
    private JDialog dialog;
    private final Class<? extends IndexableField>[] presetFieldClasses = new Class[]{TextField.class, StringField.class, IntPoint.class, LongPoint.class, FloatPoint.class, DoublePoint.class, SortedDocValuesField.class, SortedSetDocValuesField.class, NumericDocValuesField.class, SortedNumericDocValuesField.class, StoredField.class, Field.class};

    public static synchronized AddDocumentDialogFactory getInstance() throws IOException {
        if (instance == null) {
            instance = new AddDocumentDialogFactory();
        }
        return instance;
    }

    private AddDocumentDialogFactory() throws IOException {
        this.prefs = PreferencesFactory.getInstance();
        this.indexHandler = IndexHandler.getInstance();
        this.tabSwitcher = TabSwitcherProxy.getInstance();
        this.operatorRegistry = ComponentOperatorRegistry.getInstance();
        this.indexOptionsDialogFactory = IndexOptionsDialogFactory.getInstance();
        this.helpDialogFactory = HelpDialogFactory.getInstance();
        this.newFieldList = IntStream.range(0, 50).mapToObj(i -> NewField.newInstance()).collect(Collectors.toList());
        this.operatorRegistry.register(AddDocumentDialogOperator.class, this);
        this.indexHandler.addObserver(new Observer());
        this.initialize();
    }

    private void initialize() {
        this.addBtn.setText(MessageUtils.getLocalizedMessage("add_document.button.add"));
        this.addBtn.setMargin(new Insets(3, 3, 3, 3));
        this.addBtn.setEnabled(true);
        this.addBtn.addActionListener(this.listeners::addDocument);
        this.closeBtn.setText(MessageUtils.getLocalizedMessage("button.cancel"));
        this.closeBtn.setMargin(new Insets(3, 3, 3, 3));
        this.closeBtn.addActionListener(e -> this.dialog.dispose());
        this.infoTA.setRows(3);
        this.infoTA.setLineWrap(true);
        this.infoTA.setEditable(false);
        this.infoTA.setText(MessageUtils.getLocalizedMessage("add_document.info"));
        this.infoTA.setForeground(Color.gray);
    }

    @Override
    public JDialog create(Window owner, String title, int width, int height) {
        this.dialog = new JDialog(owner, title, Dialog.ModalityType.APPLICATION_MODAL);
        this.dialog.add(this.content());
        this.dialog.setSize(new Dimension(width, height));
        this.dialog.setLocationRelativeTo(owner);
        this.dialog.getContentPane().setBackground(this.prefs.getColorTheme().getBackgroundColor());
        return this.dialog;
    }

    private JPanel content() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        panel.add((Component)this.header(), "First");
        panel.add((Component)this.center(), "Center");
        panel.add((Component)this.footer(), "Last");
        return panel;
    }

    private JPanel header() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 3));
        JPanel analyzerHeader = new JPanel(new FlowLayout(3, 10, 10));
        analyzerHeader.setOpaque(false);
        analyzerHeader.add(new JLabel(MessageUtils.getLocalizedMessage("add_document.label.analyzer")));
        analyzerHeader.add(this.analyzerNameLbl);
        JLabel changeLbl = new JLabel(MessageUtils.getLocalizedMessage("add_document.hyperlink.change"));
        changeLbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AddDocumentDialogFactory.this.dialog.dispose();
                AddDocumentDialogFactory.this.tabSwitcher.switchTab(TabbedPaneProvider.Tab.ANALYZER);
            }
        });
        analyzerHeader.add(FontUtils.toLinkText(changeLbl));
        panel.add(analyzerHeader);
        return panel;
    }

    private JPanel center() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel tableHeader = new JPanel(new FlowLayout(3, 10, 5));
        tableHeader.setOpaque(false);
        tableHeader.add(new JLabel(MessageUtils.getLocalizedMessage("add_document.label.fields")));
        panel.add((Component)tableHeader, "First");
        JScrollPane scrollPane = new JScrollPane(this.fieldsTable());
        scrollPane.setOpaque(false);
        scrollPane.getViewport().setOpaque(false);
        panel.add((Component)scrollPane, "Center");
        JPanel tableFooter = new JPanel(new FlowLayout(4, 10, 5));
        tableFooter.setOpaque(false);
        this.addBtn.setEnabled(true);
        tableFooter.add(this.addBtn);
        tableFooter.add(this.closeBtn);
        panel.add((Component)tableFooter, "Last");
        return panel;
    }

    private JTable fieldsTable() {
        JTable fieldsTable = new JTable();
        TableUtils.setupTable(fieldsTable, 0, new FieldsTableModel(this.newFieldList), null, 30, 150, 120, 80);
        fieldsTable.setShowGrid(true);
        JComboBox<Class<? extends IndexableField>> typesCombo = new JComboBox<Class<? extends IndexableField>>(this.presetFieldClasses);
        typesCombo.setRenderer((list, value, index, isSelected, cellHasFocus) -> new JLabel(value.getSimpleName()));
        fieldsTable.getColumnModel().getColumn(FieldsTableModel.Column.TYPE.getIndex()).setCellEditor(new DefaultCellEditor(typesCombo));
        for (int i = 0; i < fieldsTable.getModel().getRowCount(); ++i) {
            fieldsTable.getModel().setValueAt(TextField.class, i, FieldsTableModel.Column.TYPE.getIndex());
        }
        fieldsTable.getColumnModel().getColumn(FieldsTableModel.Column.TYPE.getIndex()).setHeaderRenderer(new HelpHeaderRenderer("About Type", "Select Field Class:", this.createTypeHelpDialog(), this.helpDialogFactory, this.dialog));
        fieldsTable.getColumnModel().getColumn(FieldsTableModel.Column.TYPE.getIndex()).setCellRenderer(new TypeCellRenderer());
        fieldsTable.getColumnModel().getColumn(FieldsTableModel.Column.OPTIONS.getIndex()).setCellRenderer(new OptionsCellRenderer(this.dialog, this.indexOptionsDialogFactory, this.newFieldList));
        return fieldsTable;
    }

    private JComponent createTypeHelpDialog() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        JTextArea descTA = new JTextArea();
        JPanel header = new JPanel();
        header.setOpaque(false);
        header.setLayout(new BoxLayout(header, 3));
        String[] typeList = new String[]{"TextField", "StringField", "IntPoint", "LongPoint", "FloatPoint", "DoublePoint", "SortedDocValuesField", "SortedSetDocValuesField", "NumericDocValuesField", "SortedNumericDocValuesField", "StoredField", "Field"};
        JPanel wrapper1 = new JPanel(new FlowLayout(3));
        wrapper1.setOpaque(false);
        JComboBox<String> typeCombo = new JComboBox<String>(typeList);
        typeCombo.setSelectedItem(typeList[0]);
        typeCombo.addActionListener(e -> {
            String selected = (String)typeCombo.getSelectedItem();
            descTA.setText(MessageUtils.getLocalizedMessage("help.fieldtype." + selected));
        });
        wrapper1.add(typeCombo);
        header.add(wrapper1);
        JPanel wrapper2 = new JPanel(new FlowLayout(3));
        wrapper2.setOpaque(false);
        wrapper2.add(new JLabel("Brief description and Examples"));
        header.add(wrapper2);
        panel.add((Component)header, "First");
        descTA.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        descTA.setEditable(false);
        descTA.setLineWrap(true);
        descTA.setRows(10);
        descTA.setText(MessageUtils.getLocalizedMessage("help.fieldtype." + typeList[0]));
        JScrollPane scrollPane = new JScrollPane(descTA);
        panel.add((Component)scrollPane, "Center");
        return panel;
    }

    private JPanel footer() {
        JPanel panel = new JPanel(new GridLayout(1, 1));
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JScrollPane scrollPane = new JScrollPane(this.infoTA);
        scrollPane.setOpaque(false);
        scrollPane.getViewport().setOpaque(false);
        panel.add(scrollPane);
        return panel;
    }

    @Override
    public void setAnalyzer(Analyzer analyzer) {
        this.analyzerNameLbl.setText(analyzer.getClass().getName());
    }

    static final class OptionsCellRenderer
    implements TableCellRenderer {
        private JDialog dialog;
        private final IndexOptionsDialogFactory indexOptionsDialogFactory;
        private final List<NewField> newFieldList;
        private final JPanel panel = new JPanel();
        private JTable table;

        public OptionsCellRenderer(JDialog dialog, IndexOptionsDialogFactory indexOptionsDialogFactory, List<NewField> newFieldList) {
            this.dialog = dialog;
            this.indexOptionsDialogFactory = indexOptionsDialogFactory;
            this.newFieldList = newFieldList;
        }

        @Override
        public Component getTableCellRendererComponent(final JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (table != null && this.table != table) {
                this.table = table;
                JTableHeader header = table.getTableHeader();
                if (header != null) {
                    this.panel.setLayout(new FlowLayout(1, 0, 0));
                    this.panel.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                    this.panel.add(new JLabel(value.toString()));
                    JLabel optionsLbl = new JLabel("options");
                    table.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            int row = table.rowAtPoint(e.getPoint());
                            int col = table.columnAtPoint(e.getPoint());
                            if (row >= 0 && col == FieldsTableModel.Column.OPTIONS.getIndex()) {
                                String title = "Index options for:";
                                new DialogOpener<IndexOptionsDialogFactory>(indexOptionsDialogFactory).open(dialog, title, 500, 500, factory -> factory.setNewField(newFieldList.get(row)), new String[0]);
                            }
                        }
                    });
                    this.panel.add(FontUtils.toLinkText(optionsLbl));
                }
            }
            return this.panel;
        }
    }

    static final class TypeCellRenderer
    implements TableCellRenderer {
        TypeCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String simpleName = ((Class)value).getSimpleName();
            return new JLabel(simpleName);
        }
    }

    static final class FieldsTableModel
    extends TableModelBase<Column> {
        private final List<NewField> newFieldList;

        FieldsTableModel(List<NewField> newFieldList) {
            super(newFieldList.size());
            this.newFieldList = newFieldList;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == Column.OPTIONS.getIndex()) {
                return "";
            }
            return this.data[rowIndex][columnIndex];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != Column.OPTIONS.getIndex();
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            this.data[rowIndex][columnIndex] = value;
            this.fireTableCellUpdated(rowIndex, columnIndex);
            NewField selectedField = this.newFieldList.get(rowIndex);
            if (columnIndex == Column.DEL.getIndex()) {
                selectedField.setDeleted((Boolean)value);
            } else if (columnIndex == Column.NAME.getIndex()) {
                selectedField.setName((String)value);
            } else if (columnIndex == Column.TYPE.getIndex()) {
                selectedField.setType((Class)value);
                selectedField.resetFieldType((Class)value);
                selectedField.setStored(selectedField.getFieldType().stored());
            } else if (columnIndex == Column.VALUE.getIndex()) {
                selectedField.setValue((String)value);
            }
        }

        protected Column[] columnInfos() {
            return Column.values();
        }

        static enum Column implements TableColumnInfo
        {
            DEL("Del", 0, Boolean.class),
            NAME("Name", 1, String.class),
            TYPE("Type", 2, Class.class),
            OPTIONS("Options", 3, String.class),
            VALUE("Value", 4, String.class);

            private String colName;
            private int index;
            private Class<?> type;

            private Column(String colName, int index, Class<?> type) {
                this.colName = colName;
                this.index = index;
                this.type = type;
            }

            @Override
            public String getColName() {
                return this.colName;
            }

            @Override
            public int getIndex() {
                return this.index;
            }

            @Override
            public Class<?> getType() {
                return this.type;
            }
        }
    }

    private class Observer
    implements IndexObserver {
        private Observer() {
        }

        @Override
        public void openIndex(LukeState state) {
            AddDocumentDialogFactory.this.toolsModel = AddDocumentDialogFactory.this.toolsFactory.newInstance(state.getIndexReader(), state.useCompound(), state.keepAllCommits());
        }

        @Override
        public void closeIndex() {
            AddDocumentDialogFactory.this.toolsModel = null;
        }
    }

    private class ListenerFunctions {
        private ListenerFunctions() {
        }

        void addDocument(ActionEvent e) {
            List validFields = AddDocumentDialogFactory.this.newFieldList.stream().filter(nf -> !nf.isDeleted()).filter(nf -> !StringUtils.isNullOrEmpty(nf.getName())).filter(nf -> !StringUtils.isNullOrEmpty(nf.getValue())).collect(Collectors.toList());
            if (validFields.isEmpty()) {
                AddDocumentDialogFactory.this.infoTA.setText("Please add one or more fields. Name and Value are both required.");
                return;
            }
            Document doc = new Document();
            try {
                for (NewField nf2 : validFields) {
                    doc.add(this.toIndexableField(nf2));
                }
            }
            catch (NumberFormatException ex) {
                log.log(Level.SEVERE, "Error converting field value", e);
                throw new LukeException("Invalid value: " + ex.getMessage(), ex);
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "Error converting field value", e);
                throw new LukeException(ex.getMessage(), ex);
            }
            this.addDocument(doc);
            log.info("Added document: " + String.valueOf(doc));
        }

        private IndexableField toIndexableField(NewField nf) throws Exception {
            if (nf.getType().equals(TextField.class) || nf.getType().equals(StringField.class)) {
                Field.Store store = nf.isStored() ? Field.Store.YES : Field.Store.NO;
                Constructor<? extends IndexableField> constr = nf.getType().getConstructor(String.class, String.class, Field.Store.class);
                return constr.newInstance(nf.getName(), nf.getValue(), store);
            }
            if (nf.getType().equals(IntPoint.class)) {
                Constructor<? extends IndexableField> constr = nf.getType().getConstructor(String.class, int[].class);
                int[] values = NumericUtils.convertToIntArray(nf.getValue(), false);
                return constr.newInstance(nf.getName(), values);
            }
            if (nf.getType().equals(LongPoint.class)) {
                Constructor<? extends IndexableField> constr = nf.getType().getConstructor(String.class, long[].class);
                long[] values = NumericUtils.convertToLongArray(nf.getValue(), false);
                return constr.newInstance(nf.getName(), values);
            }
            if (nf.getType().equals(FloatPoint.class)) {
                Constructor<? extends IndexableField> constr = nf.getType().getConstructor(String.class, float[].class);
                float[] values = NumericUtils.convertToFloatArray(nf.getValue(), false);
                return constr.newInstance(nf.getName(), values);
            }
            if (nf.getType().equals(DoublePoint.class)) {
                Constructor<? extends IndexableField> constr = nf.getType().getConstructor(String.class, double[].class);
                double[] values = NumericUtils.convertToDoubleArray(nf.getValue(), false);
                return constr.newInstance(nf.getName(), values);
            }
            if (nf.getType().equals(SortedDocValuesField.class) || nf.getType().equals(SortedSetDocValuesField.class)) {
                Constructor<? extends IndexableField> constr = nf.getType().getConstructor(String.class, BytesRef.class);
                return constr.newInstance(nf.getName(), new BytesRef((CharSequence)nf.getValue()));
            }
            if (nf.getType().equals(NumericDocValuesField.class) || nf.getType().equals(SortedNumericDocValuesField.class)) {
                Constructor<? extends IndexableField> constr = nf.getType().getConstructor(String.class, Long.TYPE);
                long value = NumericUtils.tryConvertToLongValue(nf.getValue());
                return constr.newInstance(nf.getName(), value);
            }
            if (nf.getType().equals(StoredField.class)) {
                Constructor<? extends IndexableField> constr = nf.getType().getConstructor(String.class, String.class);
                return constr.newInstance(nf.getName(), nf.getValue());
            }
            if (nf.getType().equals(Field.class)) {
                Constructor<? extends IndexableField> constr = nf.getType().getConstructor(String.class, String.class, IndexableFieldType.class);
                return constr.newInstance(nf.getName(), nf.getValue(), nf.getFieldType());
            }
            return new StringField(nf.getName(), nf.getValue(), Field.Store.YES);
        }

        private void addDocument(Document doc) {
            try {
                Analyzer analyzer = AddDocumentDialogFactory.this.operatorRegistry.get(AnalysisTabOperator.class).map(AnalysisTabOperator::getCurrentAnalyzer).orElseGet(StandardAnalyzer::new);
                AddDocumentDialogFactory.this.toolsModel.addDocument(doc, analyzer);
                AddDocumentDialogFactory.this.indexHandler.reOpen();
                AddDocumentDialogFactory.this.operatorRegistry.get(DocumentsTabOperator.class).ifPresent(DocumentsTabOperator::displayLatestDoc);
                AddDocumentDialogFactory.this.tabSwitcher.switchTab(TabbedPaneProvider.Tab.DOCUMENTS);
                AddDocumentDialogFactory.this.infoTA.setText(MessageUtils.getLocalizedMessage("add_document.message.success"));
                AddDocumentDialogFactory.this.addBtn.setEnabled(false);
                AddDocumentDialogFactory.this.closeBtn.setText(MessageUtils.getLocalizedMessage("button.close"));
            }
            catch (LukeException e) {
                AddDocumentDialogFactory.this.infoTA.setText(MessageUtils.getLocalizedMessage("add_document.message.fail"));
                throw e;
            }
            catch (Exception e) {
                AddDocumentDialogFactory.this.infoTA.setText(MessageUtils.getLocalizedMessage("add_document.message.fail"));
                throw new LukeException(e.getMessage(), e);
            }
        }
    }
}

