/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.search;

import com.carrotsearch.randomizedtesting.generators.RandomNumbers;
import java.io.IOException;
import java.util.Random;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.AbstractDocIdSetIterator;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FilterWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;

public class RandomApproximationQuery
extends Query {
    private final Query query;
    private final Random random;

    public RandomApproximationQuery(Query query, Random random) {
        this.query = query;
        this.random = random;
    }

    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        Query rewritten = this.query.rewrite(indexSearcher);
        if (rewritten != this.query) {
            return new RandomApproximationQuery(rewritten, this.random);
        }
        return super.rewrite(indexSearcher);
    }

    public void visit(QueryVisitor visitor) {
        this.query.visit(visitor);
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.query.equals((Object)((RandomApproximationQuery)((Object)other)).query);
    }

    public int hashCode() {
        return 31 * this.classHash() + this.query.hashCode();
    }

    public String toString(String field) {
        return this.query.toString(field);
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        Weight weight = this.query.createWeight(searcher, scoreMode, boost);
        return new RandomApproximationWeight(weight, new Random(this.random.nextLong()));
    }

    private static class RandomApproximationWeight
    extends FilterWeight {
        private final Random random;

        RandomApproximationWeight(Weight weight, Random random) {
            super(weight);
            this.random = random;
        }

        public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
            ScorerSupplier scorerSupplier = this.in.scorerSupplier(context);
            if (scorerSupplier == null) {
                return null;
            }
            Scorer subScorer = scorerSupplier.get(Long.MAX_VALUE);
            RandomApproximationScorer scorer = new RandomApproximationScorer(subScorer, new Random(this.random.nextLong()));
            return new Weight.DefaultScorerSupplier((Scorer)scorer);
        }
    }

    private static class RandomApproximation
    extends AbstractDocIdSetIterator {
        private final Random random;
        private final DocIdSetIterator disi;

        public RandomApproximation(Random random, DocIdSetIterator disi) {
            this.random = random;
            this.disi = disi;
        }

        public int nextDoc() throws IOException {
            return this.advance(this.doc + 1);
        }

        public int advance(int target) throws IOException {
            if (this.disi.docID() < target) {
                this.disi.advance(target);
            }
            if (this.disi.docID() == Integer.MAX_VALUE) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.doc = RandomNumbers.randomIntBetween((Random)this.random, (int)target, (int)this.disi.docID());
            return this.doc;
        }

        public long cost() {
            return this.disi.cost();
        }
    }

    public static class RandomTwoPhaseView
    extends TwoPhaseIterator {
        private final DocIdSetIterator disi;
        private int lastDoc = -1;
        private final float randomMatchCost;

        public RandomTwoPhaseView(Random random, DocIdSetIterator disi) {
            super((DocIdSetIterator)new RandomApproximation(random, disi));
            this.disi = disi;
            this.randomMatchCost = random.nextFloat() * 200.0f;
        }

        public boolean matches() throws IOException {
            if (this.approximation.docID() == -1 || this.approximation.docID() == Integer.MAX_VALUE) {
                throw new AssertionError((Object)("matches() should not be called on doc ID " + this.approximation.docID()));
            }
            if (this.lastDoc == this.approximation.docID()) {
                throw new AssertionError((Object)("matches() has been called twice on doc ID " + this.approximation.docID()));
            }
            this.lastDoc = this.approximation.docID();
            return this.approximation.docID() == this.disi.docID();
        }

        public float matchCost() {
            return this.randomMatchCost;
        }

        public int docIDRunEnd() throws IOException {
            if (this.approximation.docID() == this.disi.docID()) {
                return this.disi.docIDRunEnd();
            }
            return super.docIDRunEnd();
        }
    }

    private static class RandomApproximationScorer
    extends Scorer {
        private final Scorer scorer;
        private final RandomTwoPhaseView twoPhaseView;

        RandomApproximationScorer(Scorer scorer, Random random) {
            this.scorer = scorer;
            this.twoPhaseView = new RandomTwoPhaseView(random, scorer.iterator());
        }

        public TwoPhaseIterator twoPhaseIterator() {
            return this.twoPhaseView;
        }

        public float score() throws IOException {
            return this.scorer.score();
        }

        public int advanceShallow(int target) throws IOException {
            if (this.scorer.docID() > target && this.twoPhaseView.approximation().docID() != this.scorer.docID()) {
                target = this.scorer.docID();
            }
            return this.scorer.advanceShallow(target);
        }

        public float getMaxScore(int upTo) throws IOException {
            return this.scorer.getMaxScore(upTo);
        }

        public int docID() {
            return this.twoPhaseView.approximation().docID();
        }

        public DocIdSetIterator iterator() {
            return TwoPhaseIterator.asDocIdSetIterator((TwoPhaseIterator)this.twoPhaseView);
        }
    }
}

