/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.admission.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.admission.v1.AdmissionRequest;
import io.fabric8.kubernetes.api.model.admission.v1.AdmissionResponse;
import io.fabric8.kubernetes.api.model.admission.v1.AdmissionResponseBuilder;
import io.fabric8.kubernetes.api.model.admission.v1.AdmissionResponseFluent;
import io.fabric8.kubernetes.api.model.admission.v1.AdmissionReview;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AdmissionReviewFluent<A extends AdmissionReviewFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private String kind;
    private AdmissionRequest request;
    private AdmissionResponseBuilder response;
    private Map<String, Object> additionalProperties;

    public AdmissionReviewFluent() {
    }

    public AdmissionReviewFluent(AdmissionReview instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AdmissionReview instance) {
        AdmissionReview admissionReview = instance = instance != null ? instance : new AdmissionReview();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withRequest(instance.getRequest());
            this.withResponse(instance.getResponse());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public AdmissionRequest getRequest() {
        return this.request;
    }

    public A withRequest(AdmissionRequest request) {
        this.request = request;
        return (A)((Object)this);
    }

    public boolean hasRequest() {
        return this.request != null;
    }

    public AdmissionResponse buildResponse() {
        return this.response != null ? this.response.build() : null;
    }

    public A withResponse(AdmissionResponse response) {
        this._visitables.remove((Object)"response");
        if (response != null) {
            this.response = new AdmissionResponseBuilder(response);
            this._visitables.get((Object)"response").add(this.response);
        } else {
            this.response = null;
            this._visitables.get((Object)"response").remove((Object)this.response);
        }
        return (A)((Object)this);
    }

    public boolean hasResponse() {
        return this.response != null;
    }

    public ResponseNested<A> withNewResponse() {
        return new ResponseNested(null);
    }

    public ResponseNested<A> withNewResponseLike(AdmissionResponse item) {
        return new ResponseNested(item);
    }

    public ResponseNested<A> editResponse() {
        return this.withNewResponseLike(Optional.ofNullable(this.buildResponse()).orElse(null));
    }

    public ResponseNested<A> editOrNewResponse() {
        return this.withNewResponseLike(Optional.ofNullable(this.buildResponse()).orElse(new AdmissionResponseBuilder().build()));
    }

    public ResponseNested<A> editOrNewResponseLike(AdmissionResponse item) {
        return this.withNewResponseLike(Optional.ofNullable(this.buildResponse()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AdmissionReviewFluent that = (AdmissionReviewFluent)((Object)o);
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.request, that.request)) {
            return false;
        }
        if (!Objects.equals((Object)this.response, (Object)that.response)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.apiVersion, this.kind, this.request, this.response, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.request != null) {
            sb.append("request:");
            sb.append(this.request + ",");
        }
        if (this.response != null) {
            sb.append("response:");
            sb.append((Object)((Object)this.response) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ResponseNested<N>
    extends AdmissionResponseFluent<ResponseNested<N>>
    implements Nested<N> {
        AdmissionResponseBuilder builder;

        ResponseNested(AdmissionResponse item) {
            this.builder = new AdmissionResponseBuilder(this, item);
        }

        public N and() {
            return (N)AdmissionReviewFluent.this.withResponse(this.builder.build());
        }

        public N endResponse() {
            return this.and();
        }
    }
}

