/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.util;

import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.util.NamedThreadFactory;
import org.apache.kyuubi.util.NamedThreadFactory$;
import org.slf4j.Logger;
import scala.Function0;
import scala.concurrent.Awaitable;
import scala.concurrent.CanAwait;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration$;
import scala.runtime.BoxedUnit;

public final class ThreadUtils$
implements Logging {
    public static ThreadUtils$ MODULE$;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    static {
        new ThreadUtils$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$(this, message, t);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$(this, message);
    }

    @Override
    public void info(Function0<Object> message, Throwable t) {
        Logging.info$(this, message, t);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$(this, message);
    }

    @Override
    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    @Override
    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    public ScheduledExecutorService newDaemonSingleThreadScheduledExecutor(String threadName, boolean executeExistingDelayedTasksAfterShutdown) {
        NamedThreadFactory threadFactory = new NamedThreadFactory(threadName, true);
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, threadFactory);
        executor.setRemoveOnCancelPolicy(true);
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(executeExistingDelayedTasksAfterShutdown);
        return executor;
    }

    public boolean newDaemonSingleThreadScheduledExecutor$default$2() {
        return true;
    }

    public ThreadPoolExecutor newDaemonQueuedThreadPool(int poolSize, int poolQueueSize, long keepAliveMs, String threadPoolName) {
        NamedThreadFactory nameFactory = new NamedThreadFactory(threadPoolName, true);
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(poolQueueSize);
        this.info((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(60).append(threadPoolName).append(": pool size: ").append(poolSize).append(", wait queue size: ").append(poolQueueSize).append(",").append(" thread keepalive time: ").append(keepAliveMs).append(" ms").toString());
        ThreadPoolExecutor executor = new ThreadPoolExecutor(poolSize, poolSize, keepAliveMs, TimeUnit.MILLISECONDS, queue, nameFactory);
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    public ThreadPoolExecutor newDaemonFixedThreadPool(int nThreads, String prefix) {
        NamedThreadFactory threadFactory = new NamedThreadFactory(prefix, true);
        return (ThreadPoolExecutor)Executors.newFixedThreadPool(nThreads, threadFactory);
    }

    public ThreadPoolExecutor newDaemonCachedThreadPool(String prefix) {
        NamedThreadFactory threadFactory = new NamedThreadFactory(prefix, true);
        return (ThreadPoolExecutor)Executors.newCachedThreadPool(threadFactory);
    }

    public ScheduledThreadPoolExecutor newDaemonScheduledThreadPool(int poolSize, long keepAliveSec, String prefix, boolean removeOnCancel, boolean executeDelayedTasksAfterShutdown) {
        NamedThreadFactory threadFactory = new NamedThreadFactory(prefix, true);
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(poolSize, threadFactory);
        executor.setRemoveOnCancelPolicy(removeOnCancel);
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(executeDelayedTasksAfterShutdown);
        if (keepAliveSec > 0L) {
            executor.setKeepAliveTime(keepAliveSec, TimeUnit.SECONDS);
            executor.allowCoreThreadTimeOut(true);
        }
        this.info((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(33).append(prefix).append(": pool size: ").append(poolSize).append(", keepalive time: ").append(keepAliveSec).append(" s").toString());
        return executor;
    }

    public boolean newDaemonScheduledThreadPool$default$4() {
        return true;
    }

    public boolean newDaemonScheduledThreadPool$default$5() {
        return false;
    }

    public <T> T awaitResult(Awaitable<T> awaitable, Duration atMost) {
        T t;
        try {
            CanAwait awaitPermission = null;
            t = awaitable.result(atMost, awaitPermission);
        }
        catch (Exception e) {
            throw new KyuubiException("Exception thrown in awaitResult: ", e);
        }
        return t;
    }

    public void shutdown(ExecutorService executor, Duration gracePeriod) {
        long shutdownTimeout = gracePeriod.toMillis();
        if (executor != null) {
            executor.shutdown();
            try {
                executor.awaitTermination(shutdownTimeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                this.warn((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Exceeded timeout(").append(shutdownTimeout).append(" ms) to wait the exec-pool shutdown gracefully").toString(), e);
            }
            return;
        }
    }

    public Duration shutdown$default$2() {
        return FiniteDuration$.MODULE$.apply(30L, TimeUnit.SECONDS);
    }

    public void runInNewThread(String threadName, boolean isDaemon, Function0<BoxedUnit> body) {
        Thread thread = new Thread(threadName, body){
            private final Function0 body$1;

            public void run() {
                this.body$1.apply$mcV$sp();
            }
            {
                this.body$1 = body$1;
                super(threadName$1);
            }
        };
        thread.setDaemon(isDaemon);
        thread.setUncaughtExceptionHandler(NamedThreadFactory$.MODULE$.kyuubiUncaughtExceptionHandler());
        thread.start();
    }

    public boolean runInNewThread$default$2() {
        return true;
    }

    public void scheduleTolerableRunnableWithFixedDelay(ScheduledExecutorService scheduler, Runnable runnable, long initialDelay, long delay, TimeUnit timeUnit) {
        scheduler.scheduleWithFixedDelay(() -> {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                MODULE$.error((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Uncaught exception in thread ").append(Thread.currentThread().getName()).toString(), t);
            }
        }, initialDelay, delay, timeUnit);
    }

    private ThreadUtils$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

