/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.xbill.DNS;

import java.io.IOException;
import org.apache.hadoop.shaded.org.xbill.DNS.Compression;
import org.apache.hadoop.shaded.org.xbill.DNS.DNSInput;
import org.apache.hadoop.shaded.org.xbill.DNS.DNSOutput;
import org.apache.hadoop.shaded.org.xbill.DNS.Name;
import org.apache.hadoop.shaded.org.xbill.DNS.Record;
import org.apache.hadoop.shaded.org.xbill.DNS.Tokenizer;

public class NULLRecord
extends Record {
    private static final long serialVersionUID = -5796493183235216538L;
    private byte[] data;

    NULLRecord() {
    }

    Record getObject() {
        return new NULLRecord();
    }

    public NULLRecord(Name name, int dclass, long ttl, byte[] data) {
        super(name, 10, dclass, ttl);
        if (data.length > 65535) {
            throw new IllegalArgumentException("data must be <65536 bytes");
        }
        this.data = data;
    }

    void rrFromWire(DNSInput in) throws IOException {
        this.data = in.readByteArray();
    }

    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        throw st.exception("no defined text format for NULL records");
    }

    String rrToString() {
        return NULLRecord.unknownToString(this.data);
    }

    public byte[] getData() {
        return this.data;
    }

    void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        out.writeByteArray(this.data);
    }
}

