/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.table;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.knox.gateway.shell.table.KnoxShellTable;
import org.apache.knox.gateway.shell.table.KnoxShellTableCall;
import org.apache.knox.gateway.shell.table.KnoxShellTableCallHistory;
import org.apache.knox.gateway.shell.table.KnoxShellTableJSONSerializer;

public class KnoxShellTableRowDeserializer
extends StdDeserializer<KnoxShellTable> {
    private final KnoxShellTable table;

    KnoxShellTableRowDeserializer(KnoxShellTable table) {
        this(KnoxShellTable.class, table);
    }

    protected KnoxShellTableRowDeserializer(Class<?> vc, KnoxShellTable table) {
        super(vc);
        this.table = table;
    }

    public KnoxShellTable deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        TreeNode jsonContent = parser.readValueAsTree();
        if (jsonContent.get("callHistoryList") != null) {
            return this.parseJsonWithCallHistory(jsonContent);
        }
        return this.parseJsonWithData(jsonContent);
    }

    private KnoxShellTable parseJsonWithCallHistory(TreeNode jsonContent) throws IOException {
        List<KnoxShellTableCall> calls = this.parseCallHistoryListJSONNode(jsonContent.get("callHistoryList"));
        long tempId = KnoxShellTable.getUniqueTableId();
        KnoxShellTableCallHistory.getInstance().saveCalls(tempId, calls);
        KnoxShellTable tableFromJson = KnoxShellTableCallHistory.getInstance().replay(tempId, calls.size());
        this.table.rows = tableFromJson.rows;
        KnoxShellTableCallHistory.getInstance().removeCallsById(tempId);
        KnoxShellTableCallHistory.getInstance().removeCallsById(tableFromJson.id);
        return this.table;
    }

    private List<KnoxShellTableCall> parseCallHistoryListJSONNode(TreeNode callHistoryNode) throws IOException {
        LinkedList<KnoxShellTableCall> callHistoryList = new LinkedList<KnoxShellTableCall>();
        for (int i = 0; i < callHistoryNode.size(); ++i) {
            TreeNode callNode = callHistoryNode.get(i);
            String invokerClass = this.trimJSONQuotes(callNode.get("invokerClass").toString());
            String method = this.trimJSONQuotes(callNode.get("method").toString());
            Boolean builderMethod = Boolean.valueOf(this.trimJSONQuotes(callNode.get("builderMethod").toString()));
            Map<Object, Class<?>> params = this.fetchParameterMap(callNode.get("params"));
            callHistoryList.add(new KnoxShellTableCall(invokerClass, method, builderMethod, params));
        }
        return callHistoryList;
    }

    private Map<Object, Class<?>> fetchParameterMap(TreeNode paramsNode) throws IOException {
        try {
            HashMap parameterMap = new HashMap();
            Iterator paramsFieldNamesIterator = paramsNode.fieldNames();
            while (paramsFieldNamesIterator.hasNext()) {
                String parameterValueAsString = this.trimJSONQuotes((String)paramsFieldNamesIterator.next());
                Class<?> parameterType = Class.forName(this.trimJSONQuotes(paramsNode.get(parameterValueAsString).toString()));
                parameterMap.put(this.cast(parameterValueAsString, parameterType), parameterType);
            }
            return parameterMap;
        }
        catch (Exception e) {
            throw new IOException("Error while fetching parameters " + paramsNode, e);
        }
    }

    private Object cast(String valueAsString, Class<?> type) throws ParseException {
        if (String.class == type) {
            return valueAsString;
        }
        if (Byte.class == type) {
            return Byte.valueOf(valueAsString);
        }
        if (Short.class == type) {
            return Short.valueOf(valueAsString);
        }
        if (Integer.class == type) {
            return Integer.valueOf(valueAsString);
        }
        if (Long.class == type) {
            return Long.valueOf(valueAsString);
        }
        if (Float.class == type) {
            return Float.valueOf(valueAsString);
        }
        if (Double.class == type) {
            return Double.valueOf(valueAsString);
        }
        if (Boolean.class == type) {
            return Boolean.valueOf(valueAsString);
        }
        if (Date.class == type) {
            return KnoxShellTableJSONSerializer.JSON_DATE_FORMAT.get().parse(valueAsString);
        }
        return type.cast(valueAsString);
    }

    private KnoxShellTable parseJsonWithData(TreeNode jsonContent) {
        if (jsonContent.get("title").size() != 0) {
            this.table.title(this.trimJSONQuotes(jsonContent.get("title").toString()));
        }
        TreeNode headers = jsonContent.get("headers");
        for (int i = 0; i < headers.size(); ++i) {
            this.table.header(this.trimJSONQuotes(headers.get(i).toString()));
        }
        TreeNode rows = jsonContent.get("rows");
        for (int i = 0; i < rows.size(); ++i) {
            TreeNode row = rows.get(i);
            this.table.row();
            for (int j = 0; j < row.size(); ++j) {
                this.table.value((Comparable<? extends Object>)((Object)this.trimJSONQuotes(row.get(j).toString())));
            }
        }
        return this.table;
    }

    private String trimJSONQuotes(String toBeTrimmed) {
        return toBeTrimmed.replaceAll("\"", "");
    }
}

