/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Comparator;
import java.util.UUID;
import org.apache.directory.mavibot.btree.AbstractValueHolder;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.BTreeFactory;
import org.apache.directory.mavibot.btree.InMemoryBTreeConfiguration;
import org.apache.directory.mavibot.btree.Tuple;
import org.apache.directory.mavibot.btree.exception.BTreeOperationException;
import org.apache.directory.mavibot.btree.exception.EndOfFileExceededException;
import org.apache.directory.mavibot.btree.exception.KeyNotFoundException;

class InMemoryValueHolder<V>
extends AbstractValueHolder<V> {
    InMemoryValueHolder(BTree<?, V> parentBtree, int nbValues) {
        this.valueSerializer = parentBtree.getValueSerializer();
        if (nbValues <= 1) {
            this.valueArray = (Object[])Array.newInstance(this.valueSerializer.getType(), nbValues);
        }
    }

    InMemoryValueHolder(BTree<?, V> parentBtree, V ... values) {
        this.valueSerializer = parentBtree.getValueSerializer();
        if (values != null && values.length > 0) {
            int nbValues = values.length;
            if (nbValues == 1) {
                this.valueArray = (Object[])Array.newInstance(this.valueSerializer.getType(), nbValues);
                this.valueArray[0] = values[0];
                this.nbArrayElems = nbValues;
            } else {
                this.createSubTree();
                for (V value : values) {
                    try {
                        this.valueBtree.insert(value, value);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public int size() {
        if (this.valueBtree != null) {
            return (int)this.valueBtree.getNbElems();
        }
        return this.nbArrayElems;
    }

    @Override
    protected void createSubTree() {
        InMemoryBTreeConfiguration configuration = new InMemoryBTreeConfiguration();
        configuration.setAllowDuplicates(false);
        configuration.setName(UUID.randomUUID().toString());
        configuration.setKeySerializer(this.valueSerializer);
        configuration.setValueSerializer(this.valueSerializer);
        this.valueBtree = BTreeFactory.createInMemoryBTree(configuration);
    }

    @Override
    protected void manageSubTree() {
    }

    void setSubBtree(BTree<V, V> subBtree) {
        this.valueBtree = subBtree;
        this.valueArray = null;
    }

    @Override
    public V remove(V value) {
        V removedValue = null;
        removedValue = this.valueArray != null ? (V)this.removeFromArray(value) : (V)this.removeFromBtree(value);
        return removedValue;
    }

    private V removeFromBtree(V removedValue) {
        V returnedValue = null;
        try {
            Tuple removedTuple = this.valueBtree.delete(removedValue);
            if (removedTuple != null) {
                returnedValue = removedTuple.getKey();
            }
        }
        catch (IOException e) {
            throw new BTreeOperationException(e);
        }
        if (this.valueBtree.getNbElems() == 1L) {
            try {
                this.valueArray = (Object[])Array.newInstance(this.valueSerializer.getType(), 1);
                this.valueArray[0] = this.valueBtree.browse().next().getKey();
                this.nbArrayElems = 1;
                this.valueBtree.close();
                this.valueBtree = null;
            }
            catch (EndOfFileExceededException e) {
                throw new BTreeOperationException(e);
            }
            catch (IOException e) {
                throw new BTreeOperationException(e);
            }
            catch (KeyNotFoundException knfe) {
                throw new BTreeOperationException(knfe);
            }
        }
        return returnedValue;
    }

    private V removeFromArray(V value) {
        Comparator<Object> comparator = this.valueSerializer.getComparator();
        int result = comparator.compare(this.valueArray[0], value);
        if (result != 0) {
            return null;
        }
        Object returnedValue = this.valueArray[0];
        this.nbArrayElems = 0;
        return (V)returnedValue;
    }

    @Override
    public boolean contains(V checkedValue) {
        if (this.valueBtree != null) {
            try {
                return this.valueBtree.hasKey(checkedValue);
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
            catch (KeyNotFoundException knfe) {
                knfe.printStackTrace();
                return false;
            }
        }
        Comparator<Object> comparator = this.valueSerializer.getComparator();
        int result = comparator.compare(checkedValue, this.valueArray[0]);
        return result == 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ValueHolder[").append(this.valueSerializer.getClass().getSimpleName());
        if (this.valueBtree != null) {
            sb.append(", SubBTree");
        } else {
            sb.append(", {");
            if (this.size() != 0) {
                sb.append(this.valueArray[0]);
            }
            sb.append("}");
        }
        sb.append("]");
        return sb.toString();
    }
}

