/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.commands;

import java.io.PrintStream;
import java.net.URLDecoder;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.camel.commands.AbstractContextCommand;
import org.apache.camel.commands.CamelController;
import org.apache.camel.util.URISupport;

public class RestRegistryListCommand
extends AbstractContextCommand {
    private static final String URL_COLUMN_NAME = "Url";
    private static final String BASE_PATH_LABEL = "Base Path";
    private static final String URI_TEMPLATE_LABEL = "Uri Template";
    private static final String METHOD_COLUMN_LABEL = "Method";
    private static final String STATE_COLUMN_LABEL = "State";
    private static final String ROUTE_COLUMN_LABEL = "Route Id";
    private static final int DEFAULT_COLUMN_WIDTH_INCREMENT = 0;
    private static final String DEFAULT_FIELD_PREAMBLE = " ";
    private static final String DEFAULT_FIELD_POSTAMBLE = " ";
    private static final String DEFAULT_HEADER_PREAMBLE = " ";
    private static final String DEFAULT_HEADER_POSTAMBLE = " ";
    private static final int DEFAULT_FORMAT_BUFFER_LENGTH = 24;
    private static final int MAX_COLUMN_WIDTH = 120;
    private static final int MIN_COLUMN_WIDTH = 12;
    boolean decode = true;
    boolean verbose;

    public RestRegistryListCommand(String context, boolean decode, boolean verbose) {
        super(context);
        this.decode = decode;
        this.verbose = verbose;
    }

    @Override
    protected Object performContextCommand(CamelController camelController, String contextName, PrintStream out, PrintStream err) throws Exception {
        List<Map<String, String>> services = camelController.getRestServices(contextName);
        if (services.isEmpty()) {
            out.print("There are no REST services");
            return null;
        }
        Map<String, Integer> columnWidths = this.computeColumnWidths(services);
        String headerFormat = this.buildFormatString(columnWidths, true, this.verbose);
        String rowFormat = this.buildFormatString(columnWidths, false, this.verbose);
        if (services.size() > 0) {
            if (this.verbose) {
                out.println(String.format(headerFormat, URL_COLUMN_NAME, BASE_PATH_LABEL, URI_TEMPLATE_LABEL, METHOD_COLUMN_LABEL, STATE_COLUMN_LABEL, ROUTE_COLUMN_LABEL));
                out.println(String.format(headerFormat, "---", "---------", "------------", "------", "-----", "--------"));
            } else {
                out.println(String.format(headerFormat, BASE_PATH_LABEL, URI_TEMPLATE_LABEL, METHOD_COLUMN_LABEL, STATE_COLUMN_LABEL, ROUTE_COLUMN_LABEL));
                out.println(String.format(headerFormat, "---------", "------------", "------", "-----", "--------"));
            }
            for (Map<String, String> row : services) {
                String uri = null;
                if (this.verbose) {
                    uri = row.get("url");
                    if (this.decode) {
                        uri = URLDecoder.decode(uri, "UTF-8");
                    }
                    uri = URISupport.sanitizeUri((String)uri);
                }
                String basePath = row.get("basePath");
                String uriTemplate = row.get("uriTemplate") != null ? row.get("uriTemplate") : "";
                String method = row.get("method");
                String state = row.get("state");
                String route = row.get("routeId");
                if (this.verbose) {
                    out.println(String.format(rowFormat, uri, basePath, uriTemplate, method, state, route));
                    continue;
                }
                out.println(String.format(rowFormat, basePath, uriTemplate, method, state, route));
            }
        }
        return null;
    }

    private Map<String, Integer> computeColumnWidths(List<Map<String, String>> services) throws Exception {
        int maxUriLen = 0;
        int maxBasePathLen = 0;
        int maxUriTemplateLen = 0;
        int maxMethodLen = 0;
        int maxStatusLen = 0;
        int maxRouteLen = 0;
        for (Map<String, String> row : services) {
            String uri = row.get("url");
            if (this.decode) {
                uri = URLDecoder.decode(uri, "UTF-8");
            }
            maxUriLen = Math.max(maxUriLen, (uri = URISupport.sanitizeUri((String)uri)) == null ? 0 : uri.length());
            String basePath = row.get("basePath");
            maxBasePathLen = Math.max(maxBasePathLen, basePath == null ? 0 : basePath.length());
            String uriTemplate = row.get("uriTemplate");
            maxUriTemplateLen = Math.max(maxUriTemplateLen, uriTemplate == null ? 0 : uriTemplate.length());
            String method = row.get("method");
            maxMethodLen = Math.max(maxMethodLen, method == null ? 0 : method.length());
            String status = row.get("state");
            maxStatusLen = Math.max(maxStatusLen, status == null ? 0 : status.length());
            String routeId = row.get("routeId");
            maxRouteLen = Math.max(maxRouteLen, routeId == null ? 0 : routeId.length());
        }
        Hashtable<String, Integer> retval = new Hashtable<String, Integer>();
        retval.put(URL_COLUMN_NAME, maxUriLen);
        retval.put(BASE_PATH_LABEL, maxBasePathLen);
        retval.put(URI_TEMPLATE_LABEL, maxUriTemplateLen);
        retval.put(METHOD_COLUMN_LABEL, maxMethodLen);
        retval.put(STATE_COLUMN_LABEL, maxStatusLen);
        retval.put(ROUTE_COLUMN_LABEL, maxRouteLen);
        return retval;
    }

    private String buildFormatString(Map<String, Integer> columnWidths, boolean isHeader, boolean isVerbose) {
        String fieldPostamble;
        String fieldPreamble;
        if (isHeader) {
            fieldPreamble = " ";
            fieldPostamble = " ";
        } else {
            fieldPreamble = " ";
            fieldPostamble = " ";
        }
        int columnWidthIncrement = 0;
        int uriLen = Math.min(columnWidths.get(URL_COLUMN_NAME) + columnWidthIncrement, this.getMaxColumnWidth());
        int basePathLen = Math.min(columnWidths.get(BASE_PATH_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
        int uriTemplateLen = Math.min(columnWidths.get(URI_TEMPLATE_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
        int methodLen = Math.min(columnWidths.get(METHOD_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
        int statusLen = Math.min(columnWidths.get(STATE_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
        int routeLen = Math.min(columnWidths.get(ROUTE_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
        uriLen = Math.max(12, uriLen);
        basePathLen = Math.max(12, basePathLen);
        uriTemplateLen = Math.max(12, uriTemplateLen);
        methodLen = Math.max(12, methodLen);
        statusLen = Math.max(12, statusLen);
        StringBuilder retval = new StringBuilder(24);
        if (isVerbose) {
            retval.append(fieldPreamble).append("%-").append(uriLen).append('.').append(uriLen).append('s').append(fieldPostamble).append(' ');
        }
        retval.append(fieldPreamble).append("%-").append(basePathLen).append('.').append(basePathLen).append('s').append(fieldPostamble).append(' ');
        retval.append(fieldPreamble).append("%-").append(uriTemplateLen).append('.').append(uriTemplateLen).append('s').append(fieldPostamble).append(' ');
        retval.append(fieldPreamble).append("%-").append(methodLen).append('.').append(methodLen).append('s').append(fieldPostamble).append(' ');
        retval.append(fieldPreamble).append("%-").append(statusLen).append('.').append(statusLen).append('s').append(fieldPostamble).append(' ');
        retval.append(fieldPreamble).append("%-").append(routeLen).append('.').append(routeLen).append('s').append(fieldPostamble).append(' ');
        return retval.toString();
    }

    private int getMaxColumnWidth() {
        if (this.verbose) {
            return Integer.MAX_VALUE;
        }
        return 120;
    }
}

