/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.syncope;

import java.util.Map;
import org.apache.karaf.jaas.modules.BackingEngine;
import org.apache.karaf.jaas.modules.BackingEngineFactory;
import org.apache.karaf.jaas.modules.JAASUtils;
import org.apache.karaf.jaas.modules.syncope.SyncopeBackingEngine;
import org.apache.karaf.jaas.modules.syncope.SyncopeLoginModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncopeBackingEngineFactory
implements BackingEngineFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncopeBackingEngineFactory.class);

    @Override
    public BackingEngine build(Map<String, ?> options) {
        SyncopeBackingEngine instance = null;
        String address = JAASUtils.getString(options, "address");
        String adminUser = JAASUtils.getString(options, "admin.user");
        String adminPassword = JAASUtils.getString(options, "admin.password");
        String version = JAASUtils.getString(options, "version");
        try {
            instance = new SyncopeBackingEngine(address, version, adminUser, adminPassword);
        }
        catch (Exception e) {
            LOGGER.error("Error creating the Syncope backing engine", (Throwable)e);
        }
        return instance;
    }

    @Override
    public String getModuleClass() {
        return SyncopeLoginModule.class.getName();
    }
}

