/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.download.impl;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.karaf.features.internal.download.DownloadCallback;
import org.apache.karaf.features.internal.download.DownloadManager;
import org.apache.karaf.features.internal.download.Downloader;
import org.apache.karaf.features.internal.download.StreamProvider;
import org.apache.karaf.features.internal.download.impl.AbstractDownloadTask;
import org.apache.karaf.features.internal.download.impl.AbstractRetryableDownloadTask;
import org.apache.karaf.features.internal.download.impl.DownloadManagerHelper;
import org.apache.karaf.features.internal.download.impl.MavenDownloadTask;
import org.apache.karaf.features.internal.download.impl.SimpleDownloadTask;
import org.apache.karaf.features.internal.util.MultiException;
import org.ops4j.pax.url.mvn.MavenResolver;

public class MavenDownloadManager
implements DownloadManager {
    protected final MavenResolver mavenResolver;
    protected final ScheduledExecutorService executorService;
    protected final long scheduleDelay;
    protected final int scheduleMaxRun;
    protected File tmpPath;
    private final Map<String, AbstractDownloadTask> downloaded = new HashMap<String, AbstractDownloadTask>();
    private final Map<String, AbstractDownloadTask> downloading = new HashMap<String, AbstractDownloadTask>();
    private final Object lock = new Object();
    private volatile int allPending = 0;

    public MavenDownloadManager(MavenResolver mavenResolver, ScheduledExecutorService executorService, long scheduleDelay, int scheduleMaxRun) {
        this.mavenResolver = mavenResolver;
        this.executorService = executorService;
        this.scheduleDelay = scheduleDelay;
        this.scheduleMaxRun = scheduleMaxRun;
        String karafRoot = System.getProperty("karaf.home", "karaf");
        String karafData = System.getProperty("karaf.data", karafRoot + "/data");
        this.tmpPath = new File(karafData, "tmp");
    }

    public int getPending() {
        return this.allPending;
    }

    @Override
    public Downloader createDownloader() {
        return new MavenDownloader();
    }

    @Override
    public Map<String, StreamProvider> getProviders() {
        return Collections.synchronizedMap(this.downloaded);
    }

    @Override
    public void close() {
        this.executorService.shutdown();
    }

    protected AbstractDownloadTask createCustomDownloadTask(String url) {
        return new SimpleDownloadTask(this.executorService, url, this.tmpPath);
    }

    protected class MavenDownloader
    implements Downloader {
        private volatile int pending = 0;
        private final MultiException exception = new MultiException("Error");

        protected MavenDownloader() {
        }

        public int pending() {
            return this.pending;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void await() throws InterruptedException, MultiException {
            Object object = MavenDownloadManager.this.lock;
            synchronized (object) {
                while (this.pending != 0) {
                    MavenDownloadManager.this.lock.wait();
                }
            }
            this.exception.throwIfExceptions();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void download(String location, DownloadCallback downloadCallback) throws MalformedURLException {
            AbstractDownloadTask task;
            Object object = MavenDownloadManager.this.lock;
            synchronized (object) {
                task = MavenDownloadManager.this.downloaded.get(location);
                if (task == null) {
                    task = MavenDownloadManager.this.downloading.get(location);
                }
            }
            if (task == null) {
                task = this.createDownloadTask(location);
            }
            object = MavenDownloadManager.this.lock;
            synchronized (object) {
                AbstractDownloadTask prev = MavenDownloadManager.this.downloaded.get(location);
                if (prev == null) {
                    prev = MavenDownloadManager.this.downloading.get(location);
                }
                if (prev == null) {
                    MavenDownloadManager.this.downloading.put(location, task);
                    MavenDownloadManager.this.executorService.execute(task);
                } else {
                    task = prev;
                }
                ++this.pending;
                ++MavenDownloadManager.this.allPending;
            }
            AbstractDownloadTask downloadTask = task;
            task.addListener(future -> {
                try {
                    if (downloadCallback != null) {
                        downloadCallback.downloaded(downloadTask);
                    }
                    downloadTask.getFile();
                }
                catch (Throwable e) {
                    this.exception.addSuppressed(e);
                }
                finally {
                    Object object = MavenDownloadManager.this.lock;
                    synchronized (object) {
                        MavenDownloadManager.this.downloading.remove(location);
                        MavenDownloadManager.this.downloaded.put(location, downloadTask);
                        --MavenDownloadManager.this.allPending;
                        if (--this.pending == 0) {
                            MavenDownloadManager.this.lock.notifyAll();
                        }
                    }
                }
            });
        }

        protected AbstractDownloadTask createDownloadTask(String url) {
            AbstractDownloadTask task = this.doCreateDownloadTask(url);
            if (task instanceof AbstractRetryableDownloadTask) {
                AbstractRetryableDownloadTask rt = (AbstractRetryableDownloadTask)task;
                if (MavenDownloadManager.this.scheduleDelay > 0L) {
                    rt.setScheduleDelay(MavenDownloadManager.this.scheduleDelay);
                }
                if (MavenDownloadManager.this.scheduleMaxRun > 0) {
                    rt.setScheduleMaxRun(MavenDownloadManager.this.scheduleMaxRun);
                }
            }
            return task;
        }

        protected AbstractDownloadTask doCreateDownloadTask(String url) {
            String mvnUrl = DownloadManagerHelper.stripUrl(url);
            if (mvnUrl.startsWith("mvn:")) {
                if (!mvnUrl.equals(url)) {
                    return new ChainedDownloadTask(MavenDownloadManager.this.executorService, url, mvnUrl);
                }
                return new MavenDownloadTask(MavenDownloadManager.this.executorService, MavenDownloadManager.this.mavenResolver, mvnUrl);
            }
            return MavenDownloadManager.this.createCustomDownloadTask(url);
        }

        class ChainedDownloadTask
        extends AbstractDownloadTask {
            private String innerUrl;

            public ChainedDownloadTask(ScheduledExecutorService executorService, String url, String innerUrl) {
                super(executorService, url);
                this.innerUrl = innerUrl;
            }

            @Override
            public void run() {
                try {
                    MavenDownloader.this.download(this.innerUrl, provider -> {
                        try {
                            AbstractDownloadTask future = (AbstractDownloadTask)provider;
                            String file = future.getFile().toURI().toURL().toExternalForm();
                            String real = this.url.replace(this.innerUrl, file);
                            MavenDownloader.this.download(real, provider1 -> {
                                try {
                                    this.setFile(provider1.getFile());
                                }
                                catch (IOException e) {
                                    this.setException(e);
                                }
                                catch (Throwable t) {
                                    this.setException(new IOException(t));
                                }
                            });
                        }
                        catch (IOException e) {
                            this.setException(e);
                        }
                        catch (Throwable t) {
                            this.setException(new IOException(t));
                        }
                    });
                }
                catch (IOException e) {
                    this.setException(e);
                }
                catch (Throwable t) {
                    this.setException(new IOException(t));
                }
            }
        }
    }
}

