/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.diagnostic.management.internal;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.karaf.diagnostic.core.Dump;
import org.apache.karaf.diagnostic.core.DumpDestination;
import org.apache.karaf.diagnostic.management.DiagnosticDumpMBean;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagnosticDumpMBeanImpl
extends StandardMBean
implements DiagnosticDumpMBean {
    private BundleContext bundleContext;
    private SimpleDateFormat dumpFormat = new SimpleDateFormat("yyyy-MM-dd_HHmmss");
    private static final Logger LOGGER = LoggerFactory.getLogger(DiagnosticDumpMBeanImpl.class);

    public DiagnosticDumpMBeanImpl() throws NotCompliantMBeanException {
        super(DiagnosticDumpMBean.class);
    }

    @Override
    public void createDump(String name) {
        this.createDump(false, name, false, false);
    }

    @Override
    public void createDump(boolean directory, String name, boolean noThreadDump, boolean noHeapDump) {
        if (name == null || ((String)name).trim().length() == 0) {
            name = this.dumpFormat.format(new Date());
            if (!directory) {
                name = (String)name + ".zip";
            }
        }
        File target = new File((String)name);
        DumpDestination destination = directory ? Dump.directory((File)target) : Dump.zip((File)target);
        Dump.dump((BundleContext)this.bundleContext, (DumpDestination)destination, (boolean)noThreadDump, (boolean)noHeapDump);
        LOGGER.info("Created dump " + destination.toString());
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
}

