/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.snapshot;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.NumberFormat;
import java.util.Optional;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.internals.IdentitySerde;
import org.apache.kafka.snapshot.FileRawSnapshotReader;
import org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.kafka.snapshot.RecordsSnapshotReader;
import org.apache.kafka.snapshot.SnapshotPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Snapshots {
    private static final Logger log = LoggerFactory.getLogger(Snapshots.class);
    public static final String SUFFIX = ".checkpoint";
    private static final String PARTIAL_SUFFIX = String.format("%s.part", ".checkpoint");
    public static final String DELETE_SUFFIX = String.format("%s.deleted", ".checkpoint");
    private static final NumberFormat OFFSET_FORMATTER = NumberFormat.getInstance();
    private static final NumberFormat EPOCH_FORMATTER = NumberFormat.getInstance();
    private static final int OFFSET_WIDTH = 20;
    private static final int EPOCH_WIDTH = 10;
    public static final OffsetAndEpoch BOOTSTRAP_SNAPSHOT_ID = new OffsetAndEpoch(0L, 0);

    static Path snapshotDir(Path logDir) {
        return logDir;
    }

    public static String filenameFromSnapshotId(OffsetAndEpoch snapshotId) {
        return String.format("%s-%s", OFFSET_FORMATTER.format(snapshotId.offset()), EPOCH_FORMATTER.format(snapshotId.epoch()));
    }

    static Path moveRename(Path source, OffsetAndEpoch snapshotId) {
        return source.resolveSibling(Snapshots.filenameFromSnapshotId(snapshotId) + SUFFIX);
    }

    static Path deleteRenamePath(Path source, OffsetAndEpoch snapshotId) {
        return source.resolveSibling(Snapshots.filenameFromSnapshotId(snapshotId) + DELETE_SUFFIX);
    }

    public static Path snapshotPath(Path logDir, OffsetAndEpoch snapshotId) {
        return Snapshots.snapshotDir(logDir).resolve(Snapshots.filenameFromSnapshotId(snapshotId) + SUFFIX);
    }

    public static Path createTempFile(Path logDir, OffsetAndEpoch snapshotId) {
        Path dir = Snapshots.snapshotDir(logDir);
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            String prefix = String.format("%s-", Snapshots.filenameFromSnapshotId(snapshotId));
            return Files.createTempFile(dir, prefix, PARTIAL_SUFFIX, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Error creating temporary file, logDir = %s, snapshotId = %s.", dir.toAbsolutePath(), snapshotId), e);
        }
    }

    public static Optional<SnapshotPath> parse(Path path) {
        Path filename = path.getFileName();
        if (filename == null) {
            return Optional.empty();
        }
        String name = filename.toString();
        boolean partial = false;
        boolean deleted = false;
        if (name.endsWith(PARTIAL_SUFFIX)) {
            partial = true;
        } else if (name.endsWith(DELETE_SUFFIX)) {
            deleted = true;
        } else if (!name.endsWith(SUFFIX)) {
            return Optional.empty();
        }
        long endOffset = Long.parseLong(name.substring(0, 20));
        int epoch = Integer.parseInt(name.substring(21, 31));
        return Optional.of(new SnapshotPath(path, new OffsetAndEpoch(endOffset, epoch), partial, deleted));
    }

    public static boolean deleteIfExists(Path logDir, OffsetAndEpoch snapshotId) {
        Path immutablePath = Snapshots.snapshotPath(logDir, snapshotId);
        Path deletedPath = Snapshots.deleteRenamePath(immutablePath, snapshotId);
        try {
            boolean deleted = Files.deleteIfExists(immutablePath) | Files.deleteIfExists(deletedPath);
            if (deleted) {
                log.info("Deleted snapshot files for snapshot {}.", (Object)snapshotId);
            } else {
                log.info("Did not delete snapshot files for snapshot {} since they did not exist.", (Object)snapshotId);
            }
            return deleted;
        }
        catch (IOException e) {
            log.error("Error deleting snapshot files {} and {}", new Object[]{immutablePath, deletedPath, e});
            return false;
        }
    }

    public static Path markForDelete(Path logDir, OffsetAndEpoch snapshotId) {
        Path immutablePath = Snapshots.snapshotPath(logDir, snapshotId);
        Path deletedPath = Snapshots.deleteRenamePath(immutablePath, snapshotId);
        try {
            Utils.atomicMoveWithFallback((Path)immutablePath, (Path)deletedPath, (boolean)false);
            return deletedPath;
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Error renaming snapshot file from %s to %s.", immutablePath, deletedPath), e);
        }
    }

    public static long lastContainedLogTimestamp(RawSnapshotReader reader) {
        try (RecordsSnapshotReader<ByteBuffer> recordsSnapshotReader = RecordsSnapshotReader.of(reader, IdentitySerde.INSTANCE, (BufferSupplier)new BufferSupplier.GrowableBufferSupplier(), 0x800000, true);){
            long l = recordsSnapshotReader.lastContainedLogTimestamp();
            return l;
        }
    }

    public static long lastContainedLogTimestamp(Path logDir, OffsetAndEpoch snapshotId) {
        try (FileRawSnapshotReader reader = FileRawSnapshotReader.open(logDir, snapshotId);){
            long l = Snapshots.lastContainedLogTimestamp(reader);
            return l;
        }
    }

    static {
        OFFSET_FORMATTER.setMinimumIntegerDigits(20);
        OFFSET_FORMATTER.setGroupingUsed(false);
        EPOCH_FORMATTER.setMinimumIntegerDigits(10);
        EPOCH_FORMATTER.setGroupingUsed(false);
    }
}

