/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.distributed;

import java.util.Arrays;
import java.util.Locale;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ConnectProtocolCompatibility {
    EAGER{

        @Override
        public String protocol() {
            return "default";
        }

        @Override
        public short protocolVersion() {
            return 0;
        }
    }
    ,
    COMPATIBLE{

        @Override
        public String protocol() {
            return "compatible";
        }

        @Override
        public short protocolVersion() {
            return 1;
        }
    }
    ,
    SESSIONED{

        @Override
        public String protocol() {
            return "sessioned";
        }

        @Override
        public short protocolVersion() {
            return 2;
        }
    };


    public static ConnectProtocolCompatibility compatibility(String name) {
        return Arrays.stream(ConnectProtocolCompatibility.values()).filter(mode -> mode.name().equalsIgnoreCase(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown Connect protocol compatibility mode: " + name));
    }

    public static ConnectProtocolCompatibility fromProtocolVersion(short protocolVersion) {
        switch (protocolVersion) {
            case 0: {
                return EAGER;
            }
            case 1: {
                return COMPATIBLE;
            }
            case 2: {
                return SESSIONED;
            }
        }
        throw new IllegalArgumentException("Unknown Connect protocol version: " + protocolVersion);
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public abstract short protocolVersion();

    public abstract String protocol();

    public static ConnectProtocolCompatibility fromProtocol(String protocolName) {
        return Arrays.stream(ConnectProtocolCompatibility.values()).filter(mode -> mode.protocol().equalsIgnoreCase(protocolName)).findFirst().orElseThrow(() -> new IllegalArgumentException("Not found Connect protocol compatibility mode for protocol: " + protocolName));
    }
}

