/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.exec.http;

import java.io.InputStream;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.http.HttpEnv;
import org.apache.jena.http.HttpLib;
import org.apache.jena.sparql.exec.UpdateExec;
import org.apache.jena.sparql.exec.http.Params;
import org.apache.jena.sparql.exec.http.UpdateExecHTTPBuilder;
import org.apache.jena.sparql.exec.http.UpdateSendMode;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.update.UpdateRequest;

public class UpdateExecHTTP
implements UpdateExec {
    private final Context context;
    private final String service;
    private final String updateString;
    private final Map<String, String> httpHeaders;
    private final HttpClient httpClient;
    private final UpdateSendMode sendMode;
    private final Params params;
    private final List<String> usingGraphURIs;
    private final List<String> usingNamedGraphURIs;
    private final long timeout;
    private final TimeUnit timeoutUnit;
    private AtomicBoolean cancelSignal = new AtomicBoolean(false);
    private volatile InputStream retainedConnection = null;

    public static UpdateExecHTTPBuilder newBuilder() {
        return UpdateExecHTTPBuilder.create();
    }

    public static UpdateExecHTTPBuilder service(String endpointURL) {
        return (UpdateExecHTTPBuilder)UpdateExecHTTPBuilder.create().endpoint(endpointURL);
    }

    UpdateExecHTTP(String serviceURL, UpdateRequest update2, String updateString, HttpClient httpClient, Params params, List<String> usingGraphURIs, List<String> usingNamedGraphURIs, Map<String, String> httpHeaders, UpdateSendMode sendMode, Context context2, long timeout, TimeUnit timeoutUnit) {
        this.context = context2;
        this.service = serviceURL;
        this.updateString = updateString != null ? updateString : update2.toString();
        this.httpClient = HttpLib.dft(httpClient, HttpEnv.getDftHttpClient());
        this.params = params;
        this.usingGraphURIs = usingGraphURIs;
        this.usingNamedGraphURIs = usingNamedGraphURIs;
        this.httpHeaders = httpHeaders;
        this.sendMode = sendMode;
        this.timeout = timeout;
        this.timeoutUnit = timeoutUnit;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public void execute() {
        Params thisParams = Params.create(this.params);
        if (this.usingGraphURIs != null) {
            for (String uri : this.usingGraphURIs) {
                thisParams.add("using-graph-uri", uri);
            }
        }
        if (this.usingNamedGraphURIs != null) {
            for (String uri : this.usingNamedGraphURIs) {
                thisParams.add("using-named-graph-uri", uri);
            }
        }
        HttpLib.modifyByService(this.service, this.context, thisParams, this.httpHeaders);
        switch (this.sendMode) {
            case asPost: {
                this.executePostBody(thisParams);
                break;
            }
            case asPostForm: {
                this.executePostForm(thisParams);
            }
        }
    }

    private void executePostBody(Params thisParams) {
        String str2 = this.updateString;
        String requestURL = this.service;
        if (thisParams.count() > 0) {
            String qs = thisParams.httpString();
            requestURL = HttpLib.requestURL(requestURL, qs);
        }
        this.executeUpdate(requestURL, HttpRequest.BodyPublishers.ofString(str2), "application/sparql-update");
    }

    private void executePostForm(Params thisParams) {
        String requestURL = this.service;
        thisParams.add("update", this.updateString);
        String formString = thisParams.httpString();
        this.executeUpdate(requestURL, HttpRequest.BodyPublishers.ofString(formString, StandardCharsets.US_ASCII), "application/x-www-form-urlencoded");
    }

    private String executeUpdate(String requestURL, HttpRequest.BodyPublisher body, String contentType) {
        HttpRequest.Builder builder = HttpLib.requestBuilder(requestURL, this.httpHeaders, this.timeout, this.timeoutUnit);
        builder = HttpLib.contentTypeHeader(builder, contentType);
        HttpRequest request = builder.POST(body).build();
        UpdateExecHTTP.logUpdate(this.updateString, request);
        HttpResponse<InputStream> response = HttpLib.execute(this.httpClient, request);
        return HttpLib.handleResponseRtnString(response, this::setRetainedConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRetainedConnection(InputStream in) {
        AtomicBoolean atomicBoolean = this.cancelSignal;
        synchronized (atomicBoolean) {
            this.retainedConnection = in;
            if (this.cancelSignal.get()) {
                this.abort();
            }
        }
    }

    private static void logUpdate(String updateString, HttpRequest request) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        this.cancelSignal.set(true);
        AtomicBoolean atomicBoolean = this.cancelSignal;
        synchronized (atomicBoolean) {
            try {
                InputStream in = this.retainedConnection;
                if (in != null) {
                    in.close();
                    this.retainedConnection = null;
                }
            }
            catch (Exception ex) {
                Log.warn(this, "Error during abort", ex);
            }
        }
    }
}

