/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.main.cmds;

import arq.cmdline.CmdARQ;
import arq.cmdline.ModAssembler;
import arq.cmdline.ModDatasetAssembler;
import java.net.BindException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.jena.assembler.exceptions.AssemblerException;
import org.apache.jena.atlas.io.IOX;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.web.AuthScheme;
import org.apache.jena.cmd.ArgDecl;
import org.apache.jena.cmd.ArgModuleGeneral;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.cmd.CmdGeneral;
import org.apache.jena.cmd.TerminationException;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.main.FusekiServer;
import org.apache.jena.fuseki.main.cmds.ArgCustomizers;
import org.apache.jena.fuseki.main.cmds.DSGSetup;
import org.apache.jena.fuseki.main.cmds.ServerArgs;
import org.apache.jena.fuseki.main.cmds.SetupType;
import org.apache.jena.fuseki.main.sys.FusekiModule;
import org.apache.jena.fuseki.main.sys.FusekiModules;
import org.apache.jena.fuseki.main.sys.FusekiServerArgsCustomiser;
import org.apache.jena.fuseki.main.sys.InitFusekiMain;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.server.FusekiCoreInfo;
import org.apache.jena.fuseki.servlets.SPARQL_QueryGeneral;
import org.apache.jena.fuseki.validation.DataValidator;
import org.apache.jena.fuseki.validation.IRIValidator;
import org.apache.jena.fuseki.validation.LangTagValidator;
import org.apache.jena.fuseki.validation.QueryValidator;
import org.apache.jena.fuseki.validation.UpdateValidator;
import org.apache.jena.query.ARQ;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.apache.jena.sys.JenaSystem;
import org.slf4j.Logger;

public class FusekiMain
extends CmdARQ {
    public static int defaultPort = 3030;
    public static int defaultHttpsPort = 3043;
    private static ArgDecl argMem = new ArgDecl(false, "mem");
    private static ArgDecl argUpdate = new ArgDecl(false, "update", "allowUpdate");
    private static ArgDecl argFile = new ArgDecl(true, "file");
    private static ArgDecl argTDB1mode = new ArgDecl(false, "tdb1");
    private static ArgDecl argTDB2mode = new ArgDecl(false, "tdb2");
    private static ArgDecl argMemTDB = new ArgDecl(false, "memtdb", "memTDB", "tdbmem");
    private static ArgDecl argTDB = new ArgDecl(true, "loc", "location", "tdb");
    private static ArgDecl argRDFS = new ArgDecl(true, "rdfs");
    private static ArgDecl argEmpty = new ArgDecl(false, "empty", "no-dataset");
    private static ArgDecl argGeneralQuerySvc = new ArgDecl(true, "general");
    private static ArgDecl argPort = new ArgDecl(true, "port");
    private static ArgDecl argLocalhost = new ArgDecl(false, "localhost", "local");
    private static ArgDecl argTimeout = new ArgDecl(true, "timeout");
    private static ArgDecl argConfig = new ArgDecl(true, "config", "conf");
    private static ArgDecl argJettyConfig = new ArgDecl(true, "jetty-config", "jetty");
    private static ArgDecl argGZip = new ArgDecl(true, "gzip");
    private static ArgDecl argContextPath = new ArgDecl(true, "pathBase", "contextPath", "pathbase", "contextpath");
    private static ArgDecl argBase = new ArgDecl(true, "base", "files");
    private static ArgDecl argCORS = new ArgDecl(true, "withCORS", "cors", "CORS", "cors-config");
    private static ArgDecl argNoCORS = new ArgDecl(false, "noCORS", "no-cors");
    private static ArgDecl argWithPing = new ArgDecl(false, "withPing", "ping");
    private static ArgDecl argWithStats = new ArgDecl(false, "withStats", "stats");
    private static ArgDecl argWithMetrics = new ArgDecl(false, "withMetrics", "metrics");
    private static ArgDecl argWithCompact = new ArgDecl(false, "withCompact", "compact");
    private static ArgDecl argEnableModules = new ArgDecl(true, "modules", "fuseki-modules");
    private static ArgDecl argAuth = new ArgDecl(true, "auth");
    private static ArgDecl argHttps = new ArgDecl(true, "https");
    private static ArgDecl argHttpsPort = new ArgDecl(true, "httpsPort", "httpsport", "sport");
    private static ArgDecl argPasswdFile = new ArgDecl(true, "passwd");
    private static ArgDecl argRealm = new ArgDecl(true, "realm");
    private static ArgDecl argSparqler = new ArgDecl(true, "sparqler");
    private static ArgDecl argValidators = new ArgDecl(false, "validators");
    private ModDatasetAssembler modDataset = new ModDatasetAssembler();
    private List<FusekiServerArgsCustomiser> customiseServerArgs;
    private final ServerArgs serverArgs = new ServerArgs();
    private boolean useTDB2 = true;
    static String argUsage = "[--config=FILE|--mem|--loc=DIR|--file=FILE] [--port PORT] /DatasetPathName";

    public static FusekiServer.Builder builder(String ... args) {
        FusekiMain fusekiMain = new FusekiMain(args);
        fusekiMain.process();
        FusekiServer.Builder builder = FusekiServer.create();
        fusekiMain.applyServerArgs(builder, fusekiMain.serverArgs);
        return builder;
    }

    public static FusekiServer build(String ... args) {
        FusekiServer.Builder builder = FusekiMain.builder(args);
        return builder.build();
    }

    public static void run(String ... argv) {
        JenaSystem.init();
        InitFusekiMain.init();
        new FusekiMain(argv).mainRun();
    }

    @Deprecated(forRemoval=true)
    public static void addArgModule(final ArgModuleGeneral argModule) {
        FusekiServerArgsCustomiser customiser = new FusekiServerArgsCustomiser(){
            final ArgModuleGeneral argMod;
            {
                this.argMod = argModule;
            }

            @Override
            public void serverArgsModify(CmdGeneral fusekiCmd, ServerArgs serverArgs) {
                fusekiCmd.addModule(this.argMod);
            }

            @Override
            public void serverArgsPrepare(CmdGeneral fusekiCmd, ServerArgs serverArgs) {
                this.argMod.processArgs(fusekiCmd);
            }
        };
        FusekiMain.addCustomiser(customiser);
    }

    public static void addCustomiser(FusekiServerArgsCustomiser customiser) {
        Objects.requireNonNull(customiser);
        ArgCustomizers.addCustomiser(customiser);
    }

    public static void addCustomisers(FusekiModules customiserSet) {
        Objects.requireNonNull(customiserSet);
        customiserSet.forEach(customiser -> ArgCustomizers.addCustomiser(customiser));
    }

    public static void resetCustomisers() {
        ArgCustomizers.resetCustomisers();
    }

    private void applyCustomisers(Consumer<FusekiServerArgsCustomiser> action) {
        for (FusekiServerArgsCustomiser customiser : this.customiseServerArgs) {
            action.accept(customiser);
        }
    }

    protected FusekiMain(String ... argv) {
        super(argv);
        this.customiseServerArgs = List.copyOf(ArgCustomizers.get());
        this.argumentsSetup();
    }

    private void argumentsSetup() {
        this.modVersion.addClass("Fuseki", Fuseki.class);
        this.getUsage().startCategory("Fuseki");
        this.add(argConfig, "--config=FILE", "Use a configuration file to determine the services");
        this.add(argMem, "--mem", "Create an in-memory, non-persistent dataset for the server");
        this.add(argFile, "--file=FILE", "Create an in-memory, non-persistent dataset for the server, initialised with the contents of the file");
        this.add(argTDB2mode, "--tdb2", "Use TDB2 for command line persistent datasets");
        this.add(argTDB1mode, "--tdb1", "Use TDB1 for command line persistent datasets (default is TDB2)");
        this.add(argTDB, "--loc=DIR", "Use an existing TDB database (or create if does not exist)");
        this.add(argMemTDB, "--memTDB", "Create an in-memory, non-persistent dataset using TDB (testing only)");
        this.add(argRDFS, "--rdfs=FILE", "Apply RDFS on top of the dataset");
        this.add(argUpdate, "--update", "Allow updates (via SPARQL Update and SPARQL HTTP Update)");
        this.addModule(this.modDataset);
        this.add(argEmpty);
        this.add(argPort, "--port", "Listen on this port number");
        this.add(argLocalhost, "--localhost", "Listen only on the localhost interface");
        this.add(argGZip, "--gzip=on|off", "Enable GZip compression (HTTP Accept-Encoding) if request header set");
        this.add(argBase, "--base=DIR", "Directory for static content");
        this.add(argContextPath, "--contextPath=PATH", "Context path for the server");
        this.add(argHttps, "--https=CONF", "https certificate access details. JSON file { \"cert\":FILE , \"passwd\"; SECRET } ");
        this.add(argHttpsPort, "--httpsPort=NUM", "https port (default port is 3043)");
        this.add(argPasswdFile, "--passwd=FILE", "Password file");
        this.add(argTimeout, "--timeout=", "Global timeout applied to queries (value in ms) -- format is X[,Y] ");
        this.add(argSparqler, "--sparqler=DIR", "Run with SPARQLer services Directory for static content");
        this.add(argValidators, "--validators", "Install validators");
        this.add(argGeneralQuerySvc, "--general=PATH", "Add a general SPARQL endpoint (without a dataset) at /PATH");
        this.add(argAuth, "--auth=[basic|digest]", "Run the server using basic or digest authentication");
        this.add(argJettyConfig, "--jetty=FILE", "jetty.xml server configuration");
        this.add(argCORS, "--cors=FILE", "Configure CORS settings from file");
        this.add(argNoCORS, "--no-cors", "Disable CORS");
        this.add(argWithPing, "--ping", "Enable /$/ping");
        this.add(argWithStats, "--stats", "Enable /$/stats");
        this.add(argWithMetrics, "--metrics", "Enable /$/metrics");
        this.add(argWithCompact, "--compact", "Enable /$/compact/*");
        this.add(argEnableModules, "--modules=true|false", "Enable Fuseki autoloaded modules");
        this.applyCustomisers(customiser -> customiser.serverArgsModify(this, this.serverArgs));
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " " + argUsage;
    }

    @Override
    protected void processModulesAndArgs() {
        Logger log2 = Fuseki.serverLog;
        this.serverArgs.verboseLogging = super.isVerbose();
        if (!this.serverArgs.bypassStdArgs) {
            this.processStdArguments(log2);
        }
        this.applyCustomisers(customiser -> customiser.serverArgsPrepare(this, this.serverArgs));
    }

    private void processStdArguments(Logger log2) {
        boolean withModules;
        boolean allowUpdate;
        boolean startEmpty;
        int numDefinitions = 0;
        SetupType setup = SetupType.UNSET;
        if (this.contains(argMem)) {
            setup = SetupType.MEM;
            ++numDefinitions;
        }
        if (this.contains(argFile)) {
            setup = SetupType.FILE;
            ++numDefinitions;
        }
        if (this.contains(ModAssembler.assemblerDescDecl)) {
            setup = SetupType.ASSEM;
            ++numDefinitions;
        }
        if (this.contains(argTDB)) {
            setup = SetupType.TDB;
            ++numDefinitions;
        }
        if (this.contains(argMemTDB)) {
            setup = SetupType.MEMTDB;
            ++numDefinitions;
        }
        if (this.contains(argConfig)) {
            setup = SetupType.CONF;
            ++numDefinitions;
        }
        if (this.contains(argEmpty)) {
            setup = SetupType.NONE;
        }
        if (this.contains(argSparqler)) {
            setup = SetupType.SPARQLer;
        }
        if (setup == SetupType.UNSET && this.serverArgs.allowEmpty) {
            setup = SetupType.NONE;
        }
        boolean bl = startEmpty = setup == SetupType.NONE || setup == SetupType.SPARQLer;
        if (numDefinitions > 1) {
            throw new CmdException("Multiple ways providing a dataset. Only one of --mem, --file, --loc or --conf");
        }
        if (startEmpty && numDefinitions > 0) {
            throw new CmdException("Dataset provided but 'no dataset' flag given");
        }
        if (startEmpty && !this.getPositional().isEmpty()) {
            throw new CmdException("Dataset name provided but 'no dataset' flag given");
        }
        if (!startEmpty && numDefinitions == 0) {
            throw new CmdException("No dataset or configuration specified on the command line");
        }
        if (this.contains(argConfig)) {
            if (!this.getPositional().isEmpty()) {
                throw new CmdException("Can't have both a configuration file and a service name");
            }
            if (this.contains(argRDFS)) {
                throw new CmdException("Need to define RDFS setup in the configuration file");
            }
        } else {
            if (this.getPositional().size() > 1) {
                throw new CmdException("Multiple dataset path names given");
            }
            if (!startEmpty && this.getPositional().size() == 0) {
                if (setup == SetupType.UNSET) {
                    throw new CmdException("Missing dataset description and service name");
                }
                throw new CmdException("Missing service name");
            }
            if (this.getPositional().size() == 1) {
                this.serverArgs.datasetPath = DataAccessPoint.canonical(this.getPositionalArg(0));
            }
        }
        if (this.contains(argUpdate) && this.contains(argConfig)) {
            throw new CmdException("--update and a configuration file does not make sense (control using the configuration file only)");
        }
        this.serverArgs.allowUpdate = allowUpdate = this.contains(argUpdate);
        this.serverArgs.setup = setup;
        this.serverArgs.datasetDescription = "<unset>";
        if (this.contains(argTDB1mode)) {
            this.useTDB2 = false;
        }
        if (this.contains(argTDB2mode)) {
            this.useTDB2 = true;
        }
        switch (setup) {
            case CONF: {
                this.serverArgs.serverConfigFile = this.getValue(argConfig);
                break;
            }
            case MEM: {
                this.serverArgs.dsgMaker = args -> DSGSetup.setupMem(log2, args);
                break;
            }
            case FILE: {
                List<String> filenames = this.getValues(argFile);
                this.serverArgs.dsgMaker = args -> DSGSetup.setupFile(log2, filenames, args);
                break;
            }
            case TDB: {
                String directory = this.getValue(argTDB);
                this.serverArgs.dsgMaker = args -> DSGSetup.setupTDB(log2, directory, this.useTDB2, args);
                break;
            }
            case NONE: {
                this.serverArgs.startEmpty = true;
                this.serverArgs.datasetDescription = "No dataset";
                break;
            }
            case ASSEM: {
                this.serverArgs.dsgMaker = args -> DSGSetup.setupAssembler(log2, this.modDataset, args);
                break;
            }
            case MEMTDB: {
                DSGSetup.setupMemTDB(log2, this.useTDB2, this.serverArgs);
                break;
            }
            case UNSET: {
                throw new CmdException("Internal error");
            }
            case SPARQLer: {
                String filebase = this.getValue(argSparqler);
                if (!FileOps.exists(filebase)) {
                    throw new CmdException("File area not found: " + filebase);
                }
                this.serverArgs.contentDirectory = filebase;
                this.serverArgs.addGeneral = "/sparql";
                this.serverArgs.startEmpty = true;
                this.serverArgs.validators = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)setup));
            }
        }
        if (this.contains(argRDFS)) {
            String rdfsVocab = this.getValue(argRDFS);
            if (!FileOps.exists(rdfsVocab)) {
                throw new CmdException("No such file for RDFS: " + rdfsVocab);
            }
            this.serverArgs.rdfsSchemaGraph = RDFDataMgr.loadGraph(rdfsVocab);
        }
        if (this.contains(argTimeout)) {
            String str2 = this.getValue(argTimeout);
            ARQ.getContext().set(ARQ.queryTimeout, str2);
        }
        if (this.contains(argGeneralQuerySvc)) {
            Object z = this.getValue(argGeneralQuerySvc);
            if (!((String)z).startsWith("/")) {
                z = "/" + (String)z;
            }
            this.serverArgs.addGeneral = z;
        }
        if (this.contains(argValidators)) {
            this.serverArgs.validators = true;
        }
        boolean hasJettyConfigFile = this.contains(argJettyConfig);
        this.serverArgs.port = defaultPort;
        if (this.contains(argPort)) {
            if (hasJettyConfigFile) {
                throw new CmdException("Cannot specify the port and also provide a Jetty configuration file");
            }
            this.serverArgs.port = this.portNumber(argPort);
        }
        if (this.contains(argLocalhost)) {
            if (hasJettyConfigFile) {
                throw new CmdException("Cannot specify 'localhost' and also provide a Jetty configuration file");
            }
            this.serverArgs.loopback = true;
        }
        if (this.contains(argContextPath)) {
            String contextPath = this.getValue(argContextPath);
            if ((contextPath = FusekiMain.sanitizeContextPath(contextPath)) != null) {
                this.serverArgs.servletContextPath = contextPath;
            }
        }
        if (this.contains(argBase)) {
            String filebase = this.getValue(argBase);
            if (!FileOps.exists(filebase)) {
                throw new CmdException("File area not found: " + filebase);
            }
            this.serverArgs.contentDirectory = filebase;
        }
        if (this.contains(argPasswdFile)) {
            if (hasJettyConfigFile) {
                throw new CmdException("Can't specify a password file and also provide a Jetty configuration file");
            }
            this.serverArgs.passwdFile = this.getValue(argPasswdFile);
        }
        if (this.contains(argRealm)) {
            this.serverArgs.realm = this.getValue(argRealm);
        }
        if (this.contains(argHttpsPort) && !this.contains(argHttps)) {
            throw new CmdException("https port given but not certificate details via --" + argHttps.getKeyName());
        }
        if (this.contains(argHttps)) {
            String httpsSetup;
            if (hasJettyConfigFile) {
                throw new CmdException("Can't specify \"https\" and also provide a Jetty configuration file");
            }
            this.serverArgs.httpsPort = defaultHttpsPort;
            if (this.contains(argHttpsPort)) {
                this.serverArgs.httpsPort = this.portNumber(argHttpsPort);
            }
            this.serverArgs.httpsKeysDetails = httpsSetup = this.getValue(argHttps);
        }
        if (this.contains(argAuth)) {
            if (hasJettyConfigFile) {
                throw new CmdException("Can't specify authentication and also provide a Jetty configuration file");
            }
            String schemeStr = this.getValue(argAuth);
            this.serverArgs.authScheme = AuthScheme.scheme(schemeStr);
        }
        if (this.contains(argJettyConfig)) {
            String jettyConfigFile = this.getValue(argJettyConfig);
            if (!FileOps.exists(jettyConfigFile)) {
                throw new CmdException("Jetty config file not found: " + jettyConfigFile);
            }
            this.serverArgs.jettyConfigFile = jettyConfigFile;
        }
        if (withModules = this.hasValueOfTrue(argEnableModules)) {
            FusekiModules presetModules = this.serverArgs.fusekiModules;
            FusekiModules autoModules = FusekiModules.getSystemModules();
            if (presetModules == null) {
                this.serverArgs.fusekiModules = autoModules;
            } else {
                List<FusekiModule> allModules = Stream.concat(presetModules.asList().stream(), autoModules.asList().stream()).distinct().toList();
                this.serverArgs.fusekiModules = FusekiModules.create(allModules);
            }
        }
        if (this.contains(argCORS)) {
            String corsConfigFile = this.getValue(argCORS);
            if (!FileOps.exists(corsConfigFile)) {
                throw new CmdException("CORS config file not found: " + corsConfigFile);
            }
            this.serverArgs.corsConfigFile = corsConfigFile;
        } else if (this.contains(argNoCORS)) {
            this.serverArgs.withCORS = !this.contains(argNoCORS);
        }
        this.serverArgs.withPing = this.contains(argWithPing);
        this.serverArgs.withStats = this.contains(argWithStats);
        this.serverArgs.withMetrics = this.contains(argWithMetrics);
        this.serverArgs.withCompact = this.contains(argWithCompact);
    }

    private int portNumber(ArgDecl arg) {
        String portStr = this.getValue(arg);
        if (portStr.isEmpty()) {
            return -1;
        }
        try {
            int port = Integer.parseInt(portStr);
            return port;
        }
        catch (NumberFormatException ex) {
            throw new CmdException(argPort.getKeyName() + " : bad port number: '" + portStr + "'");
        }
    }

    private static String sanitizeContextPath(String contextPath) {
        if (((String)contextPath).isEmpty()) {
            return null;
        }
        if (((String)contextPath).equals("/")) {
            return null;
        }
        if (((String)contextPath).endsWith("/")) {
            throw new CmdException("Path base must not end with \"/\": '" + (String)contextPath + "'");
        }
        if (!((String)contextPath).startsWith("/")) {
            contextPath = "/" + (String)contextPath;
        }
        return contextPath;
    }

    @Override
    protected void exec() {
        FusekiCoreInfo.logCode(Fuseki.serverLog);
        FusekiServer server = this.execMakeServer();
        this.execStartServer(server);
    }

    private FusekiServer execMakeServer() {
        try {
            return this.makeServer(this.serverArgs);
        }
        catch (AssemblerException | FusekiException ex) {
            if (ex.getCause() != null) {
                System.err.println(ex.getCause().getMessage());
            } else {
                System.err.println(ex.getMessage());
            }
            throw new TerminationException(1);
        }
    }

    private void execStartServer(FusekiServer server) {
        this.infoCmd(server, Fuseki.serverLog);
        try {
            server.start();
        }
        catch (FusekiException ex) {
            if (ex.getCause() instanceof BindException) {
                if (this.serverArgs.jettyConfigFile == null) {
                    Fuseki.serverLog.error("Failed to start server: " + ex.getCause().getMessage() + ": port=" + this.serverArgs.port);
                } else {
                    Fuseki.serverLog.error("Failed to start server: " + ex.getCause().getMessage() + ": port in use");
                }
                System.exit(1);
            }
            throw ex;
        }
        catch (Exception ex) {
            throw new FusekiException("Failed to start server: " + ex.getMessage(), ex);
        }
        server.join();
        System.exit(0);
    }

    private FusekiServer makeServer(ServerArgs serverArgs) {
        FusekiServer.Builder builder = FusekiServer.create();
        this.applyServerArgs(builder, serverArgs);
        return builder.build();
    }

    private void applyServerArgs(FusekiServer.Builder builder, ServerArgs serverArgs) {
        boolean commandLineSetup;
        boolean bl = commandLineSetup = serverArgs.dataset != null || serverArgs.dsgMaker != null;
        if (serverArgs.jettyConfigFile != null) {
            builder.jettyServerConfig(serverArgs.jettyConfigFile);
        }
        builder.port(serverArgs.port);
        builder.loopback(serverArgs.loopback);
        builder.verbose(serverArgs.verboseLogging);
        if (serverArgs.addGeneral != null) {
            builder.addServlet(serverArgs.addGeneral, new SPARQL_QueryGeneral());
        }
        if (serverArgs.validators) {
            builder.addServlet("/$/validate/query", new QueryValidator());
            builder.addServlet("/$/validate/update", new UpdateValidator());
            builder.addServlet("/$/validate/iri", new IRIValidator());
            builder.addServlet("/$/validate/langtag", new LangTagValidator());
            builder.addServlet("/$/validate/data", new DataValidator());
        }
        if (!serverArgs.startEmpty) {
            if (serverArgs.serverConfigModel != null) {
                builder.parseConfig(serverArgs.serverConfigModel);
                serverArgs.datasetDescription = "Configuration: provided";
            } else if (serverArgs.serverConfigFile != null) {
                String file = serverArgs.serverConfigFile;
                if (file.startsWith("file:")) {
                    file = file.substring("file:".length());
                }
                Path path = Path.of(file, new String[0]);
                IOX.checkReadableFile(file, msg -> new CmdException((String)msg));
                serverArgs.datasetDescription = "Configuration: " + String.valueOf(path.toAbsolutePath());
                serverArgs.serverConfigModel = RDFParser.source(path).toModel();
                AssemblerUtils.prepareForAssembler(serverArgs.serverConfigModel);
                builder.parseConfig(serverArgs.serverConfigModel);
            } else {
                if (serverArgs.datasetPath == null) {
                    throw new CmdException("No URL path name for the dataset");
                }
                if (serverArgs.dataset == null) {
                    serverArgs.dsgMaker.accept(serverArgs);
                }
                if (serverArgs.dataset == null) {
                    throw new CmdException("Failed to set the dataset service");
                }
                if (serverArgs.rdfsSchemaGraph != null) {
                    DSGSetup.setupRDFS(Fuseki.serverLog, serverArgs.rdfsSchemaGraph, serverArgs);
                }
                builder.add(serverArgs.datasetPath, serverArgs.dataset, serverArgs.allowUpdate);
            }
        }
        if (serverArgs.fusekiModules != null) {
            builder.fusekiModules(serverArgs.fusekiModules);
        }
        if (serverArgs.servletContextPath != null) {
            builder.contextPath(serverArgs.servletContextPath);
        }
        if (serverArgs.contentDirectory != null) {
            builder.staticFileBase(serverArgs.contentDirectory);
        }
        if (serverArgs.passwdFile != null) {
            builder.passwordFile(serverArgs.passwdFile);
        }
        if (serverArgs.realm != null) {
            builder.realm(serverArgs.realm);
        }
        if (serverArgs.httpsKeysDetails != null) {
            builder.https(serverArgs.httpsPort, serverArgs.httpsKeysDetails);
        }
        if (serverArgs.authScheme != null) {
            builder.auth(serverArgs.authScheme);
        }
        if (serverArgs.withCORS) {
            builder.enableCors(true, serverArgs.corsConfigFile);
        }
        if (serverArgs.withPing) {
            builder.enablePing(true);
        }
        if (serverArgs.withStats) {
            builder.enableStats(true);
        }
        if (serverArgs.withMetrics) {
            builder.enableMetrics(true);
        }
        if (serverArgs.withCompact) {
            builder.enableCompact(true);
        }
        this.applyCustomisers(customiser -> customiser.serverArgsBuilder(builder, serverArgs.serverConfigModel));
    }

    private void infoCmd(FusekiServer server, Logger log2) {
        if (super.isQuiet()) {
            return;
        }
        DataAccessPointRegistry dapRegistry = DataAccessPointRegistry.get(server.getServletContext());
        if (this.serverArgs.datasetPath != null && dapRegistry.size() != 1) {
            log2.error("Expected only one dataset in the DataAccessPointRegistry");
        }
        String datasetPath = this.serverArgs.datasetPath;
        String datasetDescription = this.serverArgs.datasetDescription;
        String serverConfigFile = this.serverArgs.serverConfigFile;
        String staticFiles = this.serverArgs.contentDirectory;
        boolean verbose = this.serverArgs.verboseLogging;
        if (!super.isQuiet()) {
            FusekiCoreInfo.logServerCmdSetup(log2, verbose, dapRegistry, datasetPath, datasetDescription, serverConfigFile, staticFiles);
        }
    }

    @Override
    protected String getCommandName() {
        return "fuseki";
    }
}

