/*
 * Decompiled with CFR 0.152.
 */
package tdb2.xloader;

import java.io.IOException;
import java.io.InputStream;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.io.IOX;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.tdb1.store.bulkloader.BulkLoader;
import org.apache.jena.tdb2.DatabaseMgr;
import org.apache.jena.tdb2.sys.TDBInternal;
import org.apache.jena.tdb2.xloader.BulkLoaderX;
import tdb2.xloader.AbstractCmdxLoad;
import tdb2.xloader.CmdxBuildIndex;
import tdb2.xloader.CmdxBuildNodeTable;
import tdb2.xloader.CmdxIngestData;

public class CmdxLoader
extends AbstractCmdxLoad {
    private String TMPDIR;
    private String DIR;
    private String datafile;

    public static void main(String ... args) {
        new CmdxLoader("AIO", args).mainRun();
    }

    protected CmdxLoader(String stageName, String[] argv) {
        super(stageName, argv);
    }

    @Override
    protected void setCmdArgs() {
        super.add(argLocation, "--loc=", "Database location");
        super.add(argTmpdir, "--tmpdir=", "Temporary directory (defaults to --loc)");
        super.add(argSortThreads, "--threads=", "Number of threads; passed as an argument to sort(1)");
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " " + this.getArgsSummary();
    }

    @Override
    protected void subCheckArgs() {
    }

    @Override
    protected String getCommandName() {
        return "cmd-xloader";
    }

    @Override
    protected void exec() {
        this.TMPDIR = this.tmpdir;
        this.DIR = this.location;
        this.datafile = this.filenames.get(0);
        FileOps.ensureDir(this.TMPDIR);
        FileOps.clearAll(this.TMPDIR);
        if (!this.TMPDIR.equals(this.DIR)) {
            FileOps.ensureDir(this.DIR);
            FileOps.clearAll(this.DIR);
        }
        BulkLoader.DataTickPoint = BulkLoaderX.DataTick = 100000;
        long maxMemory = Runtime.getRuntime().maxMemory();
        System.out.printf("RAM = %,d\n", maxMemory);
        System.out.println("STEP 1 - load node table");
        this.step(() -> CmdxBuildNodeTable.main("--loc=" + this.DIR, "--threads=" + this.sortThreads, this.datafile));
        System.out.println("STEP 2 - ingest triples and quads");
        this.step(() -> CmdxIngestData.main("--loc=" + this.DIR, this.datafile));
        System.out.println("STEP 3 - build indexes");
        if (!this.isEmptyFile(this.loaderFiles.triplesFile)) {
            this.step(() -> CmdxBuildIndex.main("--loc=" + this.DIR, "--threads=" + this.sortThreads, "--index=SPO"));
            this.step(() -> CmdxBuildIndex.main("--loc=" + this.DIR, "--threads=" + this.sortThreads, "--index=POS"));
            this.step(() -> CmdxBuildIndex.main("--loc=" + this.DIR, "--threads=" + this.sortThreads, "--index=OSP"));
        }
        if (!this.isEmptyFile(this.loaderFiles.quadsFile)) {
            this.step(() -> CmdxBuildIndex.main("--loc=" + this.DIR, "--threads=" + this.sortThreads, "--index=GSPO"));
            this.step(() -> CmdxBuildIndex.main("--loc=" + this.DIR, "--threads=" + this.sortThreads, "--index=GPOS"));
            this.step(() -> CmdxBuildIndex.main("--loc=" + this.DIR, "--threads=" + this.sortThreads, "--index=GOSP"));
            this.step(() -> CmdxBuildIndex.main("--loc=" + this.DIR, "--threads=" + this.sortThreads, "--index=SPOG"));
            this.step(() -> CmdxBuildIndex.main("--loc=" + this.DIR, "--threads=" + this.sortThreads, "--index=POSG"));
            this.step(() -> CmdxBuildIndex.main("--loc=" + this.DIR, "--threads=" + this.sortThreads, "--index=OSPG"));
        }
        this.expel();
    }

    private boolean isEmptyFile(String filename) {
        boolean bl;
        block8: {
            InputStream in = IO.openFile(filename);
            try {
                int b = in.read();
                boolean bl2 = bl = b == -1;
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw IOX.exception(ex);
                }
            }
            in.close();
        }
        return bl;
    }

    private void step(Runnable action) {
        action.run();
    }

    private void expel() {
        DatasetGraph dsg = DatabaseMgr.connectDatasetGraph(this.DIR);
        TDBInternal.expel(dsg);
    }
}

