/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.time.Instant;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.eclipse.jetty.http.HttpDateTime;
import org.eclipse.jetty.util.Index;

public interface HttpCookie {
    public static final String COMMENT_ATTRIBUTE = "Comment";
    public static final String DOMAIN_ATTRIBUTE = "Domain";
    public static final String EXPIRES_ATTRIBUTE = "Expires";
    public static final String HTTP_ONLY_ATTRIBUTE = "HttpOnly";
    public static final String MAX_AGE_ATTRIBUTE = "Max-Age";
    public static final String PATH_ATTRIBUTE = "Path";
    public static final String SAME_SITE_ATTRIBUTE = "SameSite";
    public static final String SECURE_ATTRIBUTE = "Secure";
    public static final String PARTITIONED_ATTRIBUTE = "Partitioned";

    public String getName();

    public String getValue();

    public int getVersion();

    public Map<String, String> getAttributes();

    default public Instant getExpires() {
        String expires = this.getAttributes().get(EXPIRES_ATTRIBUTE);
        return expires == null ? null : HttpCookie.parseExpires(expires);
    }

    default public long getMaxAge() {
        String ma = this.getAttributes().get(MAX_AGE_ATTRIBUTE);
        return ma == null ? -1L : Long.parseLong(ma);
    }

    default public boolean isExpired() {
        if (this.getMaxAge() == 0L) {
            return true;
        }
        Instant expires = this.getExpires();
        return expires != null && Instant.now().isAfter(expires);
    }

    default public String getComment() {
        return this.getAttributes().get(COMMENT_ATTRIBUTE);
    }

    default public String getDomain() {
        return this.getAttributes().get(DOMAIN_ATTRIBUTE);
    }

    default public String getPath() {
        return this.getAttributes().get(PATH_ATTRIBUTE);
    }

    default public boolean isSecure() {
        return Boolean.parseBoolean(this.getAttributes().get(SECURE_ATTRIBUTE));
    }

    default public SameSite getSameSite() {
        return SameSite.from(this.getAttributes().get(SAME_SITE_ATTRIBUTE));
    }

    default public boolean isHttpOnly() {
        return Boolean.parseBoolean(this.getAttributes().get(HTTP_ONLY_ATTRIBUTE));
    }

    default public boolean isPartitioned() {
        return Boolean.parseBoolean(this.getAttributes().get(PARTITIONED_ATTRIBUTE));
    }

    public int hashCode();

    public boolean equals(Object var1);

    public static HttpCookie from(String name, String value) {
        return HttpCookie.from(name, value, 0, null);
    }

    public static HttpCookie from(String name, String value, Map<String, String> attributes) {
        return HttpCookie.from(name, value, 0, attributes);
    }

    public static HttpCookie from(String name, String value, int version2, Map<String, String> attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return new Immutable(name, value, version2, Collections.emptyMap());
        }
        TreeMap<String, String> attrs = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        attrs.putAll(attributes);
        return new Immutable(name, value, version2, attrs);
    }

    public static HttpCookie from(HttpCookie cookie, String ... additionalAttributes) {
        if (additionalAttributes.length % 2 != 0) {
            throw new IllegalArgumentException("additional attributes must have name and value");
        }
        TreeMap<String, String> attributes = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        attributes.putAll(Objects.requireNonNull(cookie).getAttributes());
        for (int i = 0; i < additionalAttributes.length; i += 2) {
            attributes.put(additionalAttributes[i], additionalAttributes[i + 1]);
        }
        return HttpCookie.from(cookie.getName(), cookie.getValue(), cookie.getVersion(), attributes);
    }

    public static HttpCookie from(java.net.HttpCookie httpCookie) {
        return new JavaNetHttpCookie(httpCookie);
    }

    public static Builder build(String name, String value) {
        return HttpCookie.build(name, value, 0);
    }

    public static Builder build(String name, String value, int version2) {
        return new Builder(name, value, version2);
    }

    public static Builder build(HttpCookie httpCookie) {
        Builder builder = new Builder(httpCookie.getName(), httpCookie.getValue(), httpCookie.getVersion());
        for (Map.Entry<String, String> entry : httpCookie.getAttributes().entrySet()) {
            builder = builder.attribute(entry.getKey(), entry.getValue());
        }
        return builder;
    }

    public static Builder build(java.net.HttpCookie httpCookie) {
        return new Builder(httpCookie.getName(), httpCookie.getValue(), httpCookie.getVersion()).comment(httpCookie.getComment()).domain(httpCookie.getDomain()).httpOnly(httpCookie.isHttpOnly()).maxAge(httpCookie.getMaxAge()).path(httpCookie.getPath()).secure(httpCookie.getSecure());
    }

    public static java.net.HttpCookie asJavaNetHttpCookie(HttpCookie httpCookie) {
        if (httpCookie.getSameSite() != null) {
            throw new IllegalArgumentException("SameSite attribute not supported by " + java.net.HttpCookie.class.getName());
        }
        if (httpCookie.isPartitioned()) {
            throw new IllegalArgumentException("Partitioned attribute not supported by " + java.net.HttpCookie.class.getName());
        }
        java.net.HttpCookie cookie = new java.net.HttpCookie(httpCookie.getName(), httpCookie.getValue());
        cookie.setVersion(httpCookie.getVersion());
        cookie.setComment(httpCookie.getComment());
        cookie.setDomain(httpCookie.getDomain());
        cookie.setHttpOnly(httpCookie.isHttpOnly());
        cookie.setMaxAge(httpCookie.getMaxAge());
        cookie.setPath(httpCookie.getPath());
        cookie.setSecure(httpCookie.isSecure());
        return cookie;
    }

    public static int hashCode(HttpCookie httpCookie) {
        String domain = httpCookie.getDomain();
        if (domain != null) {
            domain = domain.toLowerCase(Locale.ENGLISH);
        }
        return Objects.hash(httpCookie.getName(), domain, httpCookie.getPath());
    }

    public static boolean equals(HttpCookie cookie1, Object obj) {
        if (cookie1 == obj) {
            return true;
        }
        if (cookie1 == null || obj == null) {
            return false;
        }
        if (!(obj instanceof HttpCookie)) {
            return false;
        }
        HttpCookie cookie2 = (HttpCookie)obj;
        if (!Objects.equals(cookie1.getName(), cookie2.getName())) {
            return false;
        }
        if (!HttpCookie.equalsIgnoreCase(cookie1.getDomain(), cookie2.getDomain())) {
            return false;
        }
        return Objects.equals(cookie1.getPath(), cookie2.getPath());
    }

    private static boolean equalsIgnoreCase(String obj1, String obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.equalsIgnoreCase(obj2);
    }

    private static String asString(HttpCookie httpCookie) {
        StringBuilder builder = new StringBuilder();
        builder.append(httpCookie.getName()).append("=").append(httpCookie.getValue());
        Map<String, String> attributes = httpCookie.getAttributes();
        if (!attributes.isEmpty()) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                builder.append("; ");
                builder.append(entry.getKey()).append("=").append(entry.getValue());
            }
        }
        return builder.toString();
    }

    public static String toString(HttpCookie httpCookie) {
        return "%s@%x[%s]".formatted(httpCookie.getClass().getSimpleName(), httpCookie.hashCode(), HttpCookie.asString(httpCookie));
    }

    public static String formatExpires(Instant expires) {
        return HttpDateTime.format(expires);
    }

    public static Instant parseExpires(String expires) {
        return HttpDateTime.parse(expires).toInstant();
    }

    private static Map<String, String> lazyAttributePut(Map<String, String> attributes, String key, String value) {
        if (value == null) {
            return HttpCookie.lazyAttributeRemove(attributes, key);
        }
        if (attributes == null) {
            attributes = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        }
        attributes.put(key, value);
        return attributes;
    }

    private static Map<String, String> lazyAttributeRemove(Map<String, String> attributes, String key) {
        if (attributes == null) {
            return null;
        }
        attributes.remove(key);
        return attributes;
    }

    private static Map<String, String> lazyAttributes(Map<String, String> attributes) {
        return attributes == null || attributes.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(attributes);
    }

    public static enum SameSite {
        NONE("None"),
        STRICT("Strict"),
        LAX("Lax");

        private final String attributeValue;
        private static final Index<SameSite> CACHE;

        private SameSite(String attributeValue) {
            this.attributeValue = attributeValue;
        }

        public String getAttributeValue() {
            return this.attributeValue;
        }

        public static SameSite from(String sameSite) {
            if (sameSite == null) {
                return null;
            }
            return CACHE.get(sameSite);
        }

        static {
            CACHE = new Index.Builder().caseSensitive(false).with(SameSite.NONE.attributeValue, NONE).with(SameSite.STRICT.attributeValue, STRICT).with(SameSite.LAX.attributeValue, LAX).build();
        }
    }

    public static class Immutable
    implements HttpCookie {
        private final String _name;
        private final String _value;
        private final int _version;
        private final Map<String, String> _attributes;

        private Immutable(String name, String value, int version2, Map<String, String> attributes) {
            this._name = name;
            this._value = value;
            this._version = version2;
            this._attributes = attributes == null || attributes.isEmpty() ? Collections.emptyMap() : attributes;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public String getValue() {
            return this._value;
        }

        @Override
        public int getVersion() {
            return this._version;
        }

        @Override
        public Map<String, String> getAttributes() {
            return this._attributes;
        }

        @Override
        public int hashCode() {
            return HttpCookie.hashCode(this);
        }

        @Override
        public boolean equals(Object obj) {
            return HttpCookie.equals(this, obj);
        }

        public String toString() {
            return HttpCookie.toString(this);
        }
    }

    public static class JavaNetHttpCookie
    implements HttpCookie {
        private final java.net.HttpCookie _httpCookie;
        private Map<String, String> _attributes;

        private JavaNetHttpCookie(java.net.HttpCookie httpCookie) {
            this._httpCookie = httpCookie;
        }

        @Override
        public String getComment() {
            return this._httpCookie.getComment();
        }

        @Override
        public String getDomain() {
            return this._httpCookie.getDomain();
        }

        @Override
        public long getMaxAge() {
            return this._httpCookie.getMaxAge();
        }

        @Override
        public String getPath() {
            return this._httpCookie.getPath();
        }

        @Override
        public boolean isSecure() {
            return this._httpCookie.getSecure();
        }

        @Override
        public String getName() {
            return this._httpCookie.getName();
        }

        @Override
        public String getValue() {
            return this._httpCookie.getValue();
        }

        @Override
        public int getVersion() {
            return this._httpCookie.getVersion();
        }

        @Override
        public boolean isHttpOnly() {
            return this._httpCookie.isHttpOnly();
        }

        @Override
        public Map<String, String> getAttributes() {
            if (this._attributes == null) {
                Map<String, String> attributes = HttpCookie.lazyAttributePut(null, HttpCookie.COMMENT_ATTRIBUTE, this.getComment());
                attributes = HttpCookie.lazyAttributePut(attributes, HttpCookie.DOMAIN_ATTRIBUTE, this.getDomain());
                if (this.isHttpOnly()) {
                    attributes = HttpCookie.lazyAttributePut(attributes, HttpCookie.HTTP_ONLY_ATTRIBUTE, Boolean.TRUE.toString());
                }
                if (this.getMaxAge() >= 0L) {
                    attributes = HttpCookie.lazyAttributePut(attributes, HttpCookie.MAX_AGE_ATTRIBUTE, Long.toString(this.getMaxAge()));
                }
                attributes = HttpCookie.lazyAttributePut(attributes, HttpCookie.PATH_ATTRIBUTE, this.getPath());
                if (this.isSecure()) {
                    attributes = HttpCookie.lazyAttributePut(attributes, HttpCookie.SECURE_ATTRIBUTE, Boolean.TRUE.toString());
                }
                this._attributes = HttpCookie.lazyAttributes(attributes);
            }
            return this._attributes;
        }

        @Override
        public int hashCode() {
            return HttpCookie.hashCode(this);
        }

        @Override
        public boolean equals(Object obj) {
            return HttpCookie.equals(this, obj);
        }

        public String toString() {
            return HttpCookie.toString(this);
        }
    }

    public static class Builder {
        private final String _name;
        private final String _value;
        private final int _version;
        private Map<String, String> _attributes;

        private Builder(String name, String value, int version2) {
            this._name = name;
            this._value = value;
            this._version = version2;
        }

        public Builder attribute(String name, String value) {
            if (name == null) {
                return this;
            }
            switch (name.toLowerCase(Locale.ENGLISH)) {
                case "expires": {
                    this.expires(HttpCookie.parseExpires(value));
                    break;
                }
                case "httponly": {
                    if (!this.isTruthy(value)) {
                        throw new IllegalArgumentException("Invalid HttpOnly attribute");
                    }
                    this.httpOnly(true);
                    break;
                }
                case "max-age": {
                    this.maxAge(Long.parseLong(value));
                    break;
                }
                case "samesite": {
                    SameSite sameSite = SameSite.from(value);
                    if (sameSite == null) {
                        throw new IllegalArgumentException("Invalid SameSite attribute");
                    }
                    this.sameSite(sameSite);
                    break;
                }
                case "secure": {
                    if (!this.isTruthy(value)) {
                        throw new IllegalArgumentException("Invalid Secure attribute");
                    }
                    this.secure(true);
                    break;
                }
                case "partitioned": {
                    if (!this.isTruthy(value)) {
                        throw new IllegalArgumentException("Invalid Partitioned attribute");
                    }
                    this.partitioned(true);
                    break;
                }
                default: {
                    this._attributes = HttpCookie.lazyAttributePut(this._attributes, name, value);
                }
            }
            return this;
        }

        private boolean isTruthy(String value) {
            return value != null && (value.isEmpty() || "true".equalsIgnoreCase(value));
        }

        public Builder comment(String comment) {
            this._attributes = HttpCookie.lazyAttributePut(this._attributes, HttpCookie.COMMENT_ATTRIBUTE, comment);
            return this;
        }

        public Builder domain(String domain) {
            this._attributes = HttpCookie.lazyAttributePut(this._attributes, HttpCookie.DOMAIN_ATTRIBUTE, domain);
            return this;
        }

        public Builder httpOnly(boolean httpOnly) {
            this._attributes = httpOnly ? HttpCookie.lazyAttributePut(this._attributes, HttpCookie.HTTP_ONLY_ATTRIBUTE, Boolean.TRUE.toString()) : HttpCookie.lazyAttributeRemove(this._attributes, HttpCookie.HTTP_ONLY_ATTRIBUTE);
            return this;
        }

        public Builder maxAge(long maxAge) {
            this._attributes = maxAge >= 0L ? HttpCookie.lazyAttributePut(this._attributes, HttpCookie.MAX_AGE_ATTRIBUTE, Long.toString(maxAge)) : HttpCookie.lazyAttributeRemove(this._attributes, HttpCookie.MAX_AGE_ATTRIBUTE);
            return this;
        }

        public Builder expires(Instant expires) {
            this._attributes = expires != null ? HttpCookie.lazyAttributePut(this._attributes, HttpCookie.EXPIRES_ATTRIBUTE, HttpCookie.formatExpires(expires)) : HttpCookie.lazyAttributeRemove(this._attributes, HttpCookie.EXPIRES_ATTRIBUTE);
            return this;
        }

        public Builder path(String path) {
            this._attributes = HttpCookie.lazyAttributePut(this._attributes, HttpCookie.PATH_ATTRIBUTE, path);
            return this;
        }

        public Builder secure(boolean secure) {
            this._attributes = secure ? HttpCookie.lazyAttributePut(this._attributes, HttpCookie.SECURE_ATTRIBUTE, Boolean.TRUE.toString()) : HttpCookie.lazyAttributeRemove(this._attributes, HttpCookie.SECURE_ATTRIBUTE);
            return this;
        }

        public Builder sameSite(SameSite sameSite) {
            this._attributes = HttpCookie.lazyAttributePut(this._attributes, HttpCookie.SAME_SITE_ATTRIBUTE, sameSite.attributeValue);
            return this;
        }

        public Builder partitioned(boolean partitioned) {
            this._attributes = partitioned ? HttpCookie.lazyAttributePut(this._attributes, HttpCookie.PARTITIONED_ATTRIBUTE, Boolean.TRUE.toString()) : HttpCookie.lazyAttributeRemove(this._attributes, HttpCookie.PARTITIONED_ATTRIBUTE);
            return this;
        }

        public HttpCookie build() {
            return new Immutable(this._name, this._value, this._version, HttpCookie.lazyAttributes(this._attributes));
        }
    }

    public static class Wrapper
    implements HttpCookie {
        private final HttpCookie wrapped;

        public Wrapper(HttpCookie wrapped) {
            this.wrapped = Objects.requireNonNull(wrapped);
        }

        public HttpCookie getWrapped() {
            return this.wrapped;
        }

        @Override
        public String getName() {
            return this.getWrapped().getName();
        }

        @Override
        public String getValue() {
            return this.getWrapped().getValue();
        }

        @Override
        public int getVersion() {
            return this.getWrapped().getVersion();
        }

        @Override
        public Map<String, String> getAttributes() {
            return this.getWrapped().getAttributes();
        }

        @Override
        public Instant getExpires() {
            return this.getWrapped().getExpires();
        }

        @Override
        public long getMaxAge() {
            return this.getWrapped().getMaxAge();
        }

        @Override
        public boolean isExpired() {
            return this.getWrapped().isExpired();
        }

        @Override
        public String getComment() {
            return this.getWrapped().getComment();
        }

        @Override
        public String getDomain() {
            return this.getWrapped().getDomain();
        }

        @Override
        public String getPath() {
            return this.getWrapped().getPath();
        }

        @Override
        public boolean isSecure() {
            return this.getWrapped().isSecure();
        }

        @Override
        public SameSite getSameSite() {
            return this.getWrapped().getSameSite();
        }

        @Override
        public boolean isHttpOnly() {
            return this.getWrapped().isHttpOnly();
        }

        @Override
        public boolean isPartitioned() {
            return this.getWrapped().isPartitioned();
        }

        @Override
        public int hashCode() {
            return HttpCookie.hashCode(this);
        }

        @Override
        public boolean equals(Object obj) {
            return HttpCookie.equals(this, obj);
        }

        public String toString() {
            return HttpCookie.toString(this);
        }
    }
}

