/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.store.value;

import org.apache.jena.atlas.lib.BitsLong;

public class DoubleNode62 {
    public static final long NO_ENCODING = -72057594037927936L;
    public static final long POSITIVE_INFINITY_BITS = DoubleNode62.pack(Double.POSITIVE_INFINITY);
    public static final double POSITIVE_INFINITY = DoubleNode62.unpack(POSITIVE_INFINITY_BITS);
    public static final long NEGATIVE_INFINITY_BITS = DoubleNode62.pack(Double.NEGATIVE_INFINITY);
    public static final double NEGATIVE_INFINITY = DoubleNode62.unpack(NEGATIVE_INFINITY_BITS);
    public static final long NaN_BITS = DoubleNode62.pack(Double.NaN);
    public static final double NaN = DoubleNode62.unpack(NaN_BITS);
    public static final long MAX_VALUE_BITS = 0x1FEFFFFFFFFFFFFFL;
    public static final double MAX_VALUE = DoubleNode62.unpack(0x1FEFFFFFFFFFFFFFL);
    public static final long MIN_NORMAL_BITS = 0x10000000000000L;
    public static final double MIN_NORMAL = DoubleNode62.unpack(0x10000000000000L);
    public static final long MIN_VALUE_BITS = 1L;
    public static final double MIN_VALUE = DoubleNode62.unpack(1L);
    public static final int MAX_EXPONENT = 255;
    public static final int MIN_EXPONENT = -254;
    public static final int SIZE = 62;

    public static long pack(double v) {
        long x = Double.doubleToLongBits(v);
        long sign = BitsLong.unpack(x, 63, 64);
        long exp11 = BitsLong.unpack(x, 52, 63);
        long exp9 = DoubleNode62.encode11to9(exp11);
        if (exp9 == -1L) {
            return -72057594037927936L;
        }
        long significand = BitsLong.unpack(x, 0, 52);
        long z = 0L;
        z = BitsLong.pack(z, sign, 61, 62);
        z = BitsLong.pack(z, exp9, 52, 61);
        z = BitsLong.pack(z, significand, 0, 52);
        return z;
    }

    public static long insertType(long x) {
        return x | 0xC000000000000000L;
    }

    public static long removeType(long x) {
        return x & 0x3FFFFFFFFFFFFFFFL;
    }

    public static double unpack(long x) {
        if (x == -72057594037927936L) {
            throw new IllegalArgumentException("No encoding inline");
        }
        long sign = BitsLong.unpack(x, 61, 62);
        long exp9 = BitsLong.unpack(x, 52, 61);
        long significand = BitsLong.unpack(x, 0, 52);
        long exp11 = DoubleNode62.decode9to11(exp9);
        long z = 0L;
        z = BitsLong.pack(z, sign, 63, 64);
        z = BitsLong.pack(z, exp11, 52, 63);
        z = BitsLong.pack(z, significand, 0, 52);
        double d = Double.longBitsToDouble(z);
        return d;
    }

    private static long encode11to9(long exp11) {
        if (exp11 == 0L) {
            return 0L;
        }
        if (exp11 == 2047L) {
            return 1023L;
        }
        long expRebase = exp11 - 1023L;
        if (expRebase < -254L || expRebase > 255L) {
            return -1L;
        }
        long exp9 = expRebase + 255L;
        return exp9;
    }

    private static long decode9to11(long exp9) {
        if (exp9 == 0L) {
            return 0L;
        }
        if (exp9 == 511L) {
            return 2047L;
        }
        long expRebase = exp9 - 255L;
        long exp11 = expRebase + 1023L;
        return exp11;
    }
}

