/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.base.objectfile;

import java.nio.ByteBuffer;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.atlas.lib.Sync;
import org.apache.jena.tdb1.base.objectfile.ObjectFile;
import org.apache.jena.tdb1.lib.StringAbbrev;

public class StringFile
implements Sync,
Closeable {
    protected final ObjectFile file;
    static DumpHandler handler = new DumpHandler(){

        @Override
        public void handle(long fileIdx, String str2) {
            System.out.printf("0x%08X : %s\n", fileIdx, str2);
        }
    };
    public static final boolean compression = false;
    private static StringAbbrev abbreviations = new StringAbbrev();

    public StringFile(ObjectFile file) {
        this.file = file;
    }

    public long write(String str2) {
        str2 = this.compress(str2);
        ByteBuffer bb = ByteBuffer.allocate(4 * str2.length());
        int len = Bytes.toByteBuffer(str2, bb);
        bb.flip();
        long x = this.file.write(bb);
        return x;
    }

    public String read(long id) {
        ByteBuffer bb = this.file.read(id);
        String x = Bytes.fromByteBuffer(bb);
        x = this.decompress(x);
        return x;
    }

    @Override
    public void close() {
        this.file.close();
    }

    @Override
    public void sync() {
        this.file.sync();
    }

    public void flush() {
        this.sync();
    }

    public ObjectFile getByteBufferFile() {
        return this.file;
    }

    public void dump() {
        this.dump(handler);
    }

    public void dump(DumpHandler handler) {
        ByteBuffer bb;
        long fileIdx = 0L;
        do {
            bb = this.file.read(fileIdx);
            String str2 = Bytes.fromByteBuffer(bb);
            handler.handle(fileIdx, str2);
        } while ((fileIdx = fileIdx + (long)bb.limit() + 4L) < this.file.length());
    }

    private String compress(String str2) {
        return str2;
    }

    private String decompress(String x) {
        return x;
    }

    static {
        abbreviations.add("rdf", "<http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        abbreviations.add("rdfs", "<http://www.w3.org/2000/01/rdf-schema#");
        abbreviations.add("xsd", "<http://www.w3.org/2001/XMLSchema#");
        abbreviations.add("mal", "<http://musicbrainz.org/mm-2.1/album/");
        abbreviations.add("mt", "<http://musicbrainz.org/mm-2.1/track/");
        abbreviations.add("mar", "<http://musicbrainz.org/mm-2.1/artist/");
        abbreviations.add("mtr", "<http://musicbrainz.org/mm-2.1/trmid/");
        abbreviations.add("mc", "<http://musicbrainz.org/mm-2.1/cdindex/");
        abbreviations.add("m21", "<http://musicbrainz.org/mm/mm-2.1#");
        abbreviations.add("dc", "<http://purl.org/dc/elements/1.1/");
        abbreviations.add("r", "<http://dbpedia/resource/");
        abbreviations.add("p", "<http://dbpedia/property/");
    }

    public static interface DumpHandler {
        public void handle(long var1, String var3);
    }
}

