/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.base.file;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Comparator;
import java.util.Objects;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.atlas.lib.PropertiesSorted;
import org.apache.jena.atlas.lib.PropertyUtils;
import org.apache.jena.atlas.lib.Sync;
import org.apache.jena.tdb1.TDB1Exception;
import org.apache.jena.tdb1.sys.Names;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaFile
implements Sync,
Closeable {
    private static Comparator<String> comparator = new ComparatorKeys();
    private static Logger log = LoggerFactory.getLogger(MetaFile.class);
    private String metaFilename = null;
    private Properties properties = null;
    private String label = null;
    private boolean changed = false;
    private boolean closed = false;

    public MetaFile(String label, String fn) {
        this.label = label;
        this.metaFilename = fn;
        if (fn == null || Names.isMem((String)fn)) {
            return;
        }
        if (!((String)fn).endsWith("info")) {
            fn = (String)fn + ".info";
        }
        File f = new File((String)fn);
        this.metaFilename = f.getAbsolutePath();
        this.ensureInit();
    }

    private void ensureInit() {
        if (this.properties == null) {
            this.properties = new PropertiesSorted(comparator);
            if (this.metaFilename != null) {
                this.loadProperties();
            }
        }
    }

    public boolean existsMetaData() {
        if (this.isMem()) {
            return true;
        }
        File f = new File(this.metaFilename);
        if (f.isDirectory()) {
            log.warn("Metadata file clashes with a directory");
        }
        return f.exists() && f.isFile();
    }

    public String getFilename() {
        return this.metaFilename;
    }

    public boolean hasProperty(String key) {
        return this._getProperty(key, null) != null;
    }

    public String getProperty(String key) {
        return this._getProperty(key, null);
    }

    public String getProperty(String key, String defaultString) {
        return this._getProperty(key, defaultString);
    }

    public int getPropertyAsInteger(String key) {
        return Integer.parseInt(this._getProperty(key, null));
    }

    public int getPropertyAsInteger(String key, int defaultValue) {
        String x = this.getProperty(key);
        if (x == null) {
            return defaultValue;
        }
        return Integer.parseInt(x);
    }

    public String[] getPropertySplit(String key) {
        String str2 = this.getProperty(key);
        if (str2 == null) {
            return null;
        }
        return str2.split(",");
    }

    public String[] getPropertySplit(String key, String defaultString) {
        String str2 = this.getProperty(key, defaultString);
        return str2.split(",");
    }

    public void setProperty(String key, String value) {
        this._setProperty(key, value);
    }

    public void setProperty(String key, int value) {
        this._setProperty(key, Integer.toString(value));
    }

    public boolean propertyEquals(String key, String value) {
        return Objects.equals(this.getProperty(key), value);
    }

    public void ensurePropertySet(String key, String expected) {
        this.getOrSetDefault(key, expected);
    }

    public String getOrSetDefault(String key, String expected) {
        String x = this.getProperty(key);
        if (x == null) {
            this.setProperty(key, expected);
            x = expected;
        }
        return x;
    }

    public void checkOrSetMetadata(String key, String expected) {
        String x = this.getProperty(key);
        if (x == null) {
            this.setProperty(key, expected);
            return;
        }
        if (x.equals(expected)) {
            return;
        }
        MetaFile.inconsistent(key, x, expected);
    }

    public void checkMetadata(String key, String expected) {
        String value = this.getProperty(key);
        if (!Objects.equals(value, value)) {
            MetaFile.inconsistent(key, value, expected);
        }
    }

    private static void inconsistent(String key, String actual, String expected) {
        String msg = String.format("Inconsistent: key=%s value=%s expected=%s", key, actual == null ? "<null>" : actual, expected == null ? "<null>" : expected);
        throw new MetaFileException(msg);
    }

    public void clear() {
        this._clear();
    }

    private String _getProperty(String key, String dft) {
        this.ensureInit();
        return this.properties.getProperty(key, dft);
    }

    private void _setProperty(String key, String value) {
        this.ensureInit();
        this.properties.setProperty(key, value);
        this.changedEvent();
    }

    private void _clear() {
        this.ensureInit();
        this.properties.clear();
        this.changedEvent();
    }

    private void changedEvent() {
        this.changed = true;
    }

    private boolean isMem() {
        return Names.isMem(this.metaFilename);
    }

    public void flush() {
        if (log.isDebugEnabled()) {
            log.debug("Flush metadata (" + this.changed + "): " + this.label);
        }
        if (!this.changed) {
            return;
        }
        if (log.isDebugEnabled()) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(out);
            this.properties.list(ps);
            ps.flush();
            log.debug("\n" + out.toString());
        }
        this.saveProperties();
        this.changed = false;
    }

    private void saveProperties() {
        if (this.isMem()) {
            return;
        }
        Object str2 = this.label;
        if (str2 == null) {
            str2 = this.metaFilename;
        }
        str2 = "Metadata: " + (String)str2;
        try {
            PropertyUtils.storeToFile(this.properties, (String)str2, this.metaFilename);
        }
        catch (IOException ex) {
            log.error("Failed to store properties: " + this.metaFilename, ex);
        }
    }

    private void loadProperties() {
        if (this.isMem()) {
            this.properties = new Properties();
            return;
        }
        if (this.properties == null) {
            this.properties = new Properties();
        }
        Object in = null;
        try {
            PropertyUtils.loadFromFile(this.properties, this.metaFilename);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException ex) {
            log.error("Failed to load properties: " + this.metaFilename, ex);
        }
    }

    public void dump(PrintStream output) {
        output.println("Metafile: " + this.metaFilename);
        output.println("Label: " + this.label);
        output.println("Status: " + (this.changed ? "changed" : "unchanged"));
        if (this.properties == null) {
            output.println("#<null>");
            return;
        }
        TreeSet<Object> x = new TreeSet<Object>();
        x.addAll(this.properties.keySet());
        for (Object e2 : x) {
            String key = (String)e2;
            String value = this.properties.getProperty(key);
            output.print(key);
            output.print("=");
            output.print(value);
            output.println();
        }
    }

    @Override
    public void sync() {
        this.flush();
    }

    @Override
    public void close() {
        this.flush();
        this.closed = true;
        this.metaFilename = null;
        this.properties = null;
    }

    private static class MetaFileException
    extends TDB1Exception {
        MetaFileException(String msg) {
            super(msg);
        }
    }

    private static class ComparatorKeys
    implements Comparator<String> {
        private ComparatorKeys() {
        }

        @Override
        public int compare(String o1, String o2) {
            return -o1.compareTo(o2);
        }
    }
}

