/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rfc3986;

import org.apache.jena.rfc3986.Chars3986;

class LibParseIRI {
    private static int CASE_DIFF = 32;

    LibParseIRI() {
    }

    static boolean containsAtIgnoreCase(CharSequence string, int x, char[] chars) {
        int n = string.length();
        if (x + chars.length - 1 >= n) {
            return false;
        }
        for (int i = 0; i < chars.length; ++i) {
            char chx;
            char ch = string.charAt(x + i);
            if (ch == (chx = chars[i]) || Chars3986.range(ch, 65, 90) && chx - ch == CASE_DIFF) continue;
            return false;
        }
        return true;
    }

    public static boolean peekFor(CharSequence string, int x, char x1, char x2) {
        int n = string.length();
        if (x + 1 >= n) {
            return false;
        }
        char ch1 = string.charAt(x);
        char ch2 = string.charAt(x + 1);
        return ch1 == x1 && ch2 == x2;
    }

    public static char charAt(CharSequence string, int x) {
        if (x >= string.length()) {
            return '\uffff';
        }
        return string.charAt(x);
    }

    static boolean caseInsensitivePrefix(String string, String prefix) {
        return LibParseIRI.caseInsensitiveRegion(string, 0, prefix);
    }

    static boolean caseInsensitiveRegion(String string, int idx, String substr2) {
        return string.regionMatches(true, idx, substr2, 0, substr2.length());
    }

    static boolean region(String string, int idx, String substr2) {
        return string.regionMatches(idx, substr2, 0, substr2.length());
    }

    static String jenaIRIremoveDotSegments(String path) {
        int inputBufferStart = 0;
        int inputBufferEnd = path.length();
        StringBuilder output = new StringBuilder();
        while (inputBufferStart < inputBufferEnd) {
            String in = path.substring(inputBufferStart);
            if (in.startsWith("./")) {
                inputBufferStart += 2;
                continue;
            }
            if (in.startsWith("../")) {
                inputBufferStart += 3;
                continue;
            }
            if (in.startsWith("/./")) {
                inputBufferStart += 2;
                continue;
            }
            if (in.equals("/.")) {
                in = "/";
                inputBufferStart += 2;
            }
            if (in.startsWith("/../")) {
                inputBufferStart += 3;
                LibParseIRI.removeLastSeqment(output);
                continue;
            }
            if (in.equals("/..")) {
                in = "/";
                inputBufferStart += 3;
                LibParseIRI.removeLastSeqment(output);
            }
            if (in.equals(".")) {
                ++inputBufferStart;
                continue;
            }
            if (in.equals("..")) {
                inputBufferStart += 2;
                continue;
            }
            int nextSlash = in.indexOf(47, 1);
            if (nextSlash == -1) {
                nextSlash = in.length();
            }
            inputBufferStart += nextSlash;
            output.append(in.substring(0, nextSlash));
        }
        return output.toString();
    }

    private static void removeLastSeqment(StringBuilder output) {
        int ix = output.length();
        while (ix > 0 && output.charAt(--ix) != '/') {
        }
        output.setLength(ix);
    }
}

