/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.rdf.nquads;

import com.apicatalog.rdf.api.RdfConsumerException;
import com.apicatalog.rdf.api.RdfQuadConsumer;
import com.apicatalog.rdf.nquads.NQuadsAlphabet;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class NQuadsWriter
implements RdfQuadConsumer {
    protected final Writer writer;

    public NQuadsWriter(Writer writer) {
        this.writer = writer;
    }

    public static final String resourceOrBlank(String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        if (value.startsWith("_:")) {
            return value;
        }
        return NQuadsWriter.resource(value);
    }

    public static final String resource(String iri2) {
        if (iri2 == null) {
            throw new IllegalArgumentException();
        }
        return "<" + iri2 + ">";
    }

    public static final String literal(String literal, String datatype, String langTag, String direction) {
        if (literal == null) {
            throw new IllegalArgumentException();
        }
        StringWriter writer = new StringWriter();
        try {
            NQuadsWriter.literal(new StringWriter(), literal, datatype, langTag, direction);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    public static final String nquad(String subject, String predicate, String object, String graph) {
        StringWriter writer = new StringWriter();
        try {
            NQuadsWriter.nquad(writer, subject, predicate, object, graph);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    public static final String nquad(String subject, String predicate, String literal, String datatype, String graph) {
        StringWriter writer = new StringWriter();
        try {
            NQuadsWriter.nquad(writer, subject, predicate, literal, datatype, null, null, graph);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    public static final String nquad(String subject, String predicate, String literal, String language, String direction, String graph) {
        StringWriter writer = new StringWriter();
        try {
            NQuadsWriter.nquad(writer, subject, predicate, literal, direction != null ? "http://www.w3.org/1999/02/22-rdf-syntax-ns#dirLangString" : "http://www.w3.org/1999/02/22-rdf-syntax-ns#langString", language, direction, graph);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    public static final String nquad(String subject, String predicate, String object, String datatype, String language, String direction, String graph) {
        StringWriter writer = new StringWriter();
        try {
            NQuadsWriter.nquad(writer, subject, predicate, object, datatype, language, direction, graph);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    @Override
    public RdfQuadConsumer quad(String subject, String predicate, String object, String datatype, String language, String direction, String graph) throws RdfConsumerException {
        try {
            NQuadsWriter.nquad(this.writer, subject, predicate, object, datatype, language, direction, graph);
            return this;
        }
        catch (IOException e2) {
            throw new RdfConsumerException(subject, predicate, object, datatype, language, direction, graph, e2);
        }
    }

    protected static void nquad(Writer writer, String subject, String predicate, String object, String graph) throws IOException {
        writer.append(NQuadsWriter.resourceOrBlank(subject)).append(' ').append(NQuadsWriter.resourceOrBlank(predicate)).append(' ').append(NQuadsWriter.resourceOrBlank(object)).append(' ');
        if (graph != null) {
            writer.append(NQuadsWriter.resourceOrBlank(graph)).append(' ');
        }
        writer.append(".\n");
    }

    protected static void nquad(Writer writer, String subject, String predicate, String object, String datatype, String language, String direction, String graph) throws IOException {
        writer.append(NQuadsWriter.resourceOrBlank(subject)).append(' ').append(NQuadsWriter.resourceOrBlank(predicate)).append(' ');
        if (RdfQuadConsumer.isLiteral(datatype, language, direction)) {
            NQuadsWriter.literal(writer, object, datatype, language, direction);
        } else {
            writer.append(NQuadsWriter.resourceOrBlank(object));
        }
        writer.append(' ');
        if (graph != null) {
            writer.append(NQuadsWriter.resourceOrBlank(graph)).append(' ');
        }
        writer.append(".\n");
    }

    protected static final void literal(Writer writer, String object, String datatype, String langTag, String direction) throws IOException {
        writer.append('\"').append(NQuadsAlphabet.escape(object)).append('\"');
        if (direction != null) {
            writer.append("https://www.w3.org/ns/i18n#").append(langTag).append("_").append(direction);
        } else if (langTag != null) {
            writer.append("@").append(langTag);
        } else if (datatype != null) {
            if ("http://www.w3.org/2001/XMLSchema#string".equals(datatype)) {
                return;
            }
            writer.append("^^").append(NQuadsWriter.resource(datatype));
        }
    }
}

