/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.main;

import org.apache.jena.query.Query;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.engine.Plan;
import org.apache.jena.sparql.engine.QueryEngineFactory;
import org.apache.jena.sparql.engine.QueryEngineRegistry;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.main.QueryEngineMain;
import org.apache.jena.sparql.util.Context;

public class QueryEngineMainQuad
extends QueryEngineMain {
    private static QueryEngineFactory factory = new QueryEngineFactory(){

        @Override
        public boolean accept(Query query, DatasetGraph dataset, Context context2) {
            return true;
        }

        @Override
        public Plan create(Query query, DatasetGraph dataset, Binding input, Context context2) {
            QueryEngineMainQuad engine = new QueryEngineMainQuad(query, dataset, input, context2);
            return engine.getPlan();
        }

        @Override
        public boolean accept(Op op, DatasetGraph dataset, Context context2) {
            return true;
        }

        @Override
        public Plan create(Op op, DatasetGraph dataset, Binding binding, Context context2) {
            QueryEngineMainQuad engine = new QueryEngineMainQuad(op, dataset, binding, context2);
            return engine.getPlan();
        }
    };

    public QueryEngineMainQuad(Op op, DatasetGraph dataset, Binding input, Context context2) {
        super(op, dataset, input, context2);
    }

    public QueryEngineMainQuad(Query query, DatasetGraph dataset, Binding input, Context context2) {
        super(query, dataset, input, context2);
    }

    @Override
    protected Op modifyOp(Op op) {
        op = super.modifyOp(op);
        op = Algebra.toQuadForm(op);
        return op;
    }

    public static QueryEngineFactory getFactory() {
        return factory;
    }

    public static void register() {
        QueryEngineRegistry.addFactory(factory);
    }

    public static void unregister() {
        QueryEngineRegistry.removeFactory(factory);
    }
}

