/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jcs;

import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;

public final class JsonCanonicalizer {
    private static final DecimalFormat eFormatBigDecimal = new DecimalFormat("0E00", new DecimalFormatSymbols(Locale.ENGLISH));
    private static final DecimalFormat eFormat = new DecimalFormat("0.#######", new DecimalFormatSymbols(Locale.ENGLISH));

    public static final String canonize(JsonValue value) {
        StringWriter writer = new StringWriter();
        try {
            JsonCanonicalizer.canonize(value, writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    public static final void canonize(JsonValue value, Writer writer) throws IOException {
        JsonValue.ValueType valueType;
        JsonValue.ValueType valueType2 = valueType = value != null ? value.getValueType() : null;
        if (valueType == null || JsonValue.ValueType.NULL == valueType) {
            writer.write("null");
            return;
        }
        switch (valueType) {
            case ARRAY: {
                JsonCanonicalizer.canonizeArray(value.asJsonArray(), writer);
                break;
            }
            case OBJECT: {
                JsonCanonicalizer.canonizeObject(value.asJsonObject(), writer);
                break;
            }
            case NUMBER: {
                JsonCanonicalizer.canonizeNumber((JsonNumber)value, writer);
                break;
            }
            case FALSE: 
            case TRUE: 
            case STRING: 
            case NULL: {
                writer.write(value.toString());
            }
        }
    }

    public static final void canonizeNumber(JsonNumber number, Writer writer) throws IOException {
        String numberString = number.bigDecimalValue().compareTo(BigDecimal.ZERO) == 0 ? "0" : (number.bigDecimalValue().compareTo(BigDecimal.ONE.movePointRight(21)) >= 0 ? eFormatBigDecimal.format(number.bigDecimalValue()).replace("E", "e+") : (number.bigDecimalValue().compareTo(BigDecimal.ONE.movePointLeft(21)) <= 0 ? eFormatBigDecimal.format(number.bigDecimalValue()).toLowerCase() : eFormat.format(number.bigDecimalValue())));
        writer.write(numberString);
    }

    public static final void canonizeArray(JsonArray value, Writer writer) throws IOException {
        boolean next = false;
        writer.write("[");
        for (JsonValue item : value.asJsonArray()) {
            if (next) {
                writer.write(",");
            }
            JsonCanonicalizer.canonize(item, writer);
            next = true;
        }
        writer.write("]");
    }

    private static final void canonizeObject(JsonObject value, Writer writer) throws IOException {
        boolean next = false;
        writer.write("{");
        Set properties = value.keySet();
        if (properties != null && !properties.isEmpty()) {
            ArrayList sortedProperties = new ArrayList(properties);
            Collections.sort(sortedProperties);
            for (String propertyName : sortedProperties) {
                if (next) {
                    writer.write(",");
                }
                writer.write("\"");
                writer.write(JsonCanonicalizer.escape(propertyName));
                writer.write("\":");
                JsonValue propertyValue = (JsonValue)value.get((Object)propertyName);
                JsonCanonicalizer.canonize(propertyValue, writer);
                next = true;
            }
        }
        writer.write("}");
    }

    public static final String escape(String value) {
        int[] codePoints;
        StringBuilder escaped = new StringBuilder();
        for (int ch : codePoints = value.codePoints().toArray()) {
            if (ch == 9) {
                escaped.append("\\t");
                continue;
            }
            if (ch == 8) {
                escaped.append("\\b");
                continue;
            }
            if (ch == 10) {
                escaped.append("\\n");
                continue;
            }
            if (ch == 13) {
                escaped.append("\\r");
                continue;
            }
            if (ch == 12) {
                escaped.append("\\f");
                continue;
            }
            if (ch == 34) {
                escaped.append("\\\"");
                continue;
            }
            if (ch == 92) {
                escaped.append("\\\\");
                continue;
            }
            if (ch >= 0 && ch <= 31 || ch == 127) {
                escaped.append(String.format("\\u%04x", ch));
                continue;
            }
            escaped.appendCodePoint(ch);
        }
        return escaped.toString();
    }
}

