/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.rowset.rw;

import java.io.OutputStream;
import java.io.Writer;
import java.util.Objects;
import org.apache.jena.atlas.lib.NotImplemented;
import org.apache.jena.riot.protobuf.ProtobufRDF;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.rowset.RowSetWriter;
import org.apache.jena.riot.rowset.RowSetWriterFactory;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.resultset.ResultSetException;
import org.apache.jena.sparql.util.Context;

public class RowSetWriterProtobuf
implements RowSetWriter {
    public static RowSetWriterFactory factory = lang -> {
        if (!Objects.equals(lang, ResultSetLang.RS_Protobuf)) {
            throw new ResultSetException("RowSetWriter for RDF/Protobuf asked for a " + String.valueOf(lang));
        }
        return new RowSetWriterProtobuf();
    };

    @Override
    public void write(OutputStream out, RowSet rowSet, Context context2) {
        ProtobufRDF.writeRowSet(out, rowSet);
    }

    @Override
    public void write(Writer out, RowSet resultSet, Context context2) {
        throw new NotImplemented("Writing binary data to a java.io.Writer is not possible");
    }

    @Override
    public void write(OutputStream out, boolean result, Context context2) {
        throw new NotImplemented("No Protobuf RDF encoding defined for boolean results");
    }
}

