/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.PipelineAggregationBase;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class PercentilesBucketAggregation
extends PipelineAggregationBase
implements AggregationVariant {
    private final List<Double> percents;
    public static final JsonpDeserializer<PercentilesBucketAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PercentilesBucketAggregation::setupPercentilesBucketAggregationDeserializer);

    private PercentilesBucketAggregation(Builder builder) {
        super(builder);
        this.percents = ApiTypeHelper.unmodifiable(builder.percents);
    }

    public static PercentilesBucketAggregation of(Function<Builder, ObjectBuilder<PercentilesBucketAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.PercentilesBucket;
    }

    public final List<Double> percents() {
        return this.percents;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.percents)) {
            generator.writeKey("percents");
            generator.writeStartArray();
            for (Double item0 : this.percents) {
                generator.write(item0.doubleValue());
            }
            generator.writeEnd();
        }
    }

    protected static void setupPercentilesBucketAggregationDeserializer(ObjectDeserializer<Builder> op) {
        PipelineAggregationBase.setupPipelineAggregationBaseDeserializer(op);
        op.add(Builder::percents, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.doubleDeserializer()), "percents");
    }

    public static class Builder
    extends PipelineAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PercentilesBucketAggregation> {
        @Nullable
        private List<Double> percents;

        public final Builder percents(List<Double> list) {
            this.percents = Builder._listAddAll(this.percents, list);
            return this;
        }

        public final Builder percents(Double value, Double ... values) {
            this.percents = Builder._listAdd(this.percents, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PercentilesBucketAggregation build() {
            this._checkSingleUse();
            return new PercentilesBucketAggregation(this);
        }
    }
}

