/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory.nonstandard;

import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.factory.AbstCombFactory;
import java.time.Clock;
import java.time.Instant;
import java.util.Random;
import java.util.UUID;
import java.util.function.LongSupplier;

public final class SuffixCombFactory
extends AbstCombFactory {
    public SuffixCombFactory() {
        this(SuffixCombFactory.builder());
    }

    public SuffixCombFactory(Clock clock) {
        this((Builder)SuffixCombFactory.builder().withClock(clock));
    }

    public SuffixCombFactory(Random random) {
        this((Builder)SuffixCombFactory.builder().withRandom(random));
    }

    public SuffixCombFactory(Random random, Clock clock) {
        this((Builder)((Builder)SuffixCombFactory.builder().withRandom(random)).withClock(clock));
    }

    public SuffixCombFactory(LongSupplier randomFunction) {
        this((Builder)SuffixCombFactory.builder().withRandomFunction(randomFunction));
    }

    public SuffixCombFactory(LongSupplier randomFunction, Clock clock) {
        this((Builder)((Builder)SuffixCombFactory.builder().withRandomFunction(randomFunction)).withClock(clock));
    }

    private SuffixCombFactory(Builder builder) {
        super(UuidVersion.VERSION_RANDOM_BASED, builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UUID create() {
        this.lock.lock();
        try {
            long time = ((Instant)this.instantFunction.get()).toEpochMilli();
            long long1 = this.random.nextLong(8);
            long long2 = this.random.nextLong(2);
            UUID uUID = this.make(time, long1, long2);
            return uUID;
        }
        finally {
            this.lock.unlock();
        }
    }

    private UUID make(long time, long long1, long long2) {
        return this.toUuid(long1, long2 << 48 | time & 0xFFFFFFFFFFFFL);
    }

    public static class Builder
    extends AbstCombFactory.Builder<SuffixCombFactory, Builder> {
        @Override
        public SuffixCombFactory build() {
            return new SuffixCombFactory(this);
        }
    }
}

