/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.ssl;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.api.core.ssl.SslEngineFactory;
import com.datastax.oss.driver.internal.core.ssl.ReloadingKeyManagerFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DefaultSslEngineFactory
implements SslEngineFactory {
    private final SSLContext sslContext;
    private final String[] cipherSuites;
    private final boolean requireHostnameValidation;
    private ReloadingKeyManagerFactory kmf;

    public DefaultSslEngineFactory(DriverContext driverContext) {
        DriverExecutionProfile config = driverContext.getConfig().getDefaultProfile();
        try {
            this.sslContext = this.buildContext(config);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot initialize SSL Context", e);
        }
        if (config.isDefined(DefaultDriverOption.SSL_CIPHER_SUITES)) {
            List<String> list = config.getStringList(DefaultDriverOption.SSL_CIPHER_SUITES);
            String[] tmp = new String[list.size()];
            this.cipherSuites = list.toArray(tmp);
        } else {
            this.cipherSuites = null;
        }
        this.requireHostnameValidation = config.getBoolean(DefaultDriverOption.SSL_HOSTNAME_VALIDATION, true);
    }

    @Override
    @NonNull
    public SSLEngine newSslEngine(@NonNull EndPoint remoteEndpoint) {
        SSLEngine engine;
        SocketAddress remoteAddress = remoteEndpoint.resolve();
        if (remoteAddress instanceof InetSocketAddress) {
            InetSocketAddress socketAddress = (InetSocketAddress)remoteAddress;
            engine = this.sslContext.createSSLEngine(socketAddress.getHostName(), socketAddress.getPort());
        } else {
            engine = this.sslContext.createSSLEngine();
        }
        engine.setUseClientMode(true);
        if (this.cipherSuites != null) {
            engine.setEnabledCipherSuites(this.cipherSuites);
        }
        if (this.requireHostnameValidation) {
            SSLParameters parameters = engine.getSSLParameters();
            parameters.setEndpointIdentificationAlgorithm("HTTPS");
            engine.setSSLParameters(parameters);
        }
        return engine;
    }

    protected SSLContext buildContext(DriverExecutionProfile config) throws Exception {
        if (config.isDefined(DefaultDriverOption.SSL_KEYSTORE_PATH) || config.isDefined(DefaultDriverOption.SSL_TRUSTSTORE_PATH)) {
            SSLContext context = SSLContext.getInstance("SSL");
            TrustManagerFactory tmf = null;
            if (config.isDefined(DefaultDriverOption.SSL_TRUSTSTORE_PATH)) {
                try (InputStream tsf = Files.newInputStream(Paths.get(config.getString(DefaultDriverOption.SSL_TRUSTSTORE_PATH), new String[0]), new OpenOption[0]);){
                    KeyStore ts = KeyStore.getInstance("JKS");
                    char[] password = config.isDefined(DefaultDriverOption.SSL_TRUSTSTORE_PASSWORD) ? config.getString(DefaultDriverOption.SSL_TRUSTSTORE_PASSWORD).toCharArray() : null;
                    ts.load(tsf, password);
                    tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    tmf.init(ts);
                }
            }
            if (config.isDefined(DefaultDriverOption.SSL_KEYSTORE_PATH)) {
                this.kmf = this.buildReloadingKeyManagerFactory(config);
            }
            context.init(this.kmf != null ? this.kmf.getKeyManagers() : null, tmf != null ? tmf.getTrustManagers() : null, new SecureRandom());
            return context;
        }
        return SSLContext.getDefault();
    }

    private ReloadingKeyManagerFactory buildReloadingKeyManagerFactory(DriverExecutionProfile config) throws Exception {
        Path keystorePath = Paths.get(config.getString(DefaultDriverOption.SSL_KEYSTORE_PATH), new String[0]);
        String password = config.getString(DefaultDriverOption.SSL_KEYSTORE_PASSWORD, null);
        Optional<Duration> reloadInterval = Optional.ofNullable(config.getDuration(DefaultDriverOption.SSL_KEYSTORE_RELOAD_INTERVAL, null));
        return ReloadingKeyManagerFactory.create(keystorePath, password, reloadInterval);
    }

    @Override
    public void close() throws Exception {
        if (this.kmf != null) {
            this.kmf.close();
        }
    }
}

