/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;

class DataNodeRegionGroupUtil {
    private DataNodeRegionGroupUtil() {
    }

    static Map<TDataNodeLocation, List<TConsensusGroupId>> getLeaderDataNodeRegionGroupMap(Map<TConsensusGroupId, Integer> leaderMap, Map<TConsensusGroupId, TRegionReplicaSet> regionReplicaSetMap) {
        HashMap<TDataNodeLocation, List<TConsensusGroupId>> dataNodeConsensusGroupIdMap = new HashMap<TDataNodeLocation, List<TConsensusGroupId>>();
        regionReplicaSetMap.forEach((consensusGroupId, regionReplicaSet) -> {
            Integer leaderId = (Integer)leaderMap.get(consensusGroupId);
            TDataNodeLocation leaderDataNodeLocation = null;
            if (leaderId == null || leaderId == -1) {
                leaderDataNodeLocation = (TDataNodeLocation)regionReplicaSet.getDataNodeLocations().get(0);
            } else {
                for (TDataNodeLocation dataNodeLocation : regionReplicaSet.getDataNodeLocations()) {
                    if (dataNodeLocation.getDataNodeId() != leaderId.intValue()) continue;
                    leaderDataNodeLocation = dataNodeLocation;
                    break;
                }
            }
            dataNodeConsensusGroupIdMap.computeIfAbsent(leaderDataNodeLocation, k -> new ArrayList()).add(regionReplicaSet.getRegionId());
        });
        return dataNodeConsensusGroupIdMap;
    }

    static Map<TDataNodeLocation, List<TConsensusGroupId>> getAllReplicaDataNodeRegionGroupMap(Map<TConsensusGroupId, TRegionReplicaSet> regionReplicaSetMap) {
        HashMap<TDataNodeLocation, List<TConsensusGroupId>> dataNodeConsensusGroupIdMap = new HashMap<TDataNodeLocation, List<TConsensusGroupId>>();
        regionReplicaSetMap.forEach((consensusGroupId, regionReplicaSet) -> {
            for (TDataNodeLocation dataNodeLocation : regionReplicaSet.getDataNodeLocations()) {
                dataNodeConsensusGroupIdMap.computeIfAbsent(dataNodeLocation, k -> new ArrayList()).add(regionReplicaSet.getRegionId());
            }
        });
        return dataNodeConsensusGroupIdMap;
    }
}

