/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.subscription.topic.runtime;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.commons.subscription.meta.topic.TopicMeta;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;

public class TopicHandleMetaChangePlan
extends ConfigPhysicalPlan {
    private List<TopicMeta> topicMetaList = new ArrayList<TopicMeta>();

    public TopicHandleMetaChangePlan() {
        super(ConfigPhysicalPlanType.TopicHandleMetaChange);
    }

    public TopicHandleMetaChangePlan(List<TopicMeta> topicMetaList) {
        super(ConfigPhysicalPlanType.TopicHandleMetaChange);
        this.topicMetaList = topicMetaList;
    }

    public List<TopicMeta> getTopicMetaList() {
        return this.topicMetaList;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        stream.writeInt(this.topicMetaList.size());
        for (TopicMeta topicMeta : this.topicMetaList) {
            topicMeta.serialize((OutputStream)stream);
        }
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        int size = buffer.getInt();
        for (int i = 0; i < size; ++i) {
            TopicMeta topicMeta = TopicMeta.deserialize((ByteBuffer)buffer);
            this.topicMetaList.add(topicMeta);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TopicHandleMetaChangePlan that = (TopicHandleMetaChangePlan)obj;
        return Objects.equals(this.topicMetaList, that.topicMetaList);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.topicMetaList);
    }
}

