/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.receiver.transform.statement;

import java.time.ZoneId;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.pipe.resource.log.PipeLogger;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.pipe.receiver.transform.converter.ValueConverter;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertBaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowStatement;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeConvertedInsertRowStatement
extends InsertRowStatement {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeConvertedInsertRowStatement.class);

    public PipeConvertedInsertRowStatement(InsertRowStatement insertRowStatement) {
        Map<Integer, InsertBaseStatement.FailedMeasurementInfo> failedMeasurementIndex2Info;
        TSDataType[] dataTypes;
        String[] measurements;
        this.isDebug = insertRowStatement.isDebug();
        this.devicePath = insertRowStatement.getDevicePath();
        this.isAligned = insertRowStatement.isAligned();
        this.measurementSchemas = insertRowStatement.getMeasurementSchemas();
        this.measurements = insertRowStatement.getMeasurements();
        this.dataTypes = insertRowStatement.getDataTypes();
        this.time = insertRowStatement.getTime();
        this.values = insertRowStatement.getValues();
        this.isNeedInferType = insertRowStatement.isNeedInferType();
        MeasurementSchema[] measurementSchemas = insertRowStatement.getMeasurementSchemas();
        if (measurementSchemas != null) {
            this.measurementSchemas = Arrays.copyOf(measurementSchemas, measurementSchemas.length);
        }
        if ((measurements = insertRowStatement.getMeasurements()) != null) {
            this.measurements = Arrays.copyOf(measurements, measurements.length);
        }
        if ((dataTypes = insertRowStatement.getDataTypes()) != null) {
            this.dataTypes = Arrays.copyOf(dataTypes, dataTypes.length);
        }
        if ((failedMeasurementIndex2Info = insertRowStatement.getFailedMeasurementInfoMap()) != null) {
            this.failedMeasurementIndex2Info = new HashMap<Integer, InsertBaseStatement.FailedMeasurementInfo>(failedMeasurementIndex2Info);
        }
        this.removeAllFailedMeasurementMarks();
    }

    @Override
    protected boolean checkAndCastDataType(int columnIndex, TSDataType dataType) {
        PipeLogger.log(arg_0 -> ((Logger)LOGGER).info(arg_0), (String)"Pipe: Inserting row to %s.%s. Casting type from %s to %s.", (Object[])new Object[]{this.devicePath, this.measurements[columnIndex], this.dataTypes[columnIndex], dataType});
        this.values[columnIndex] = ValueConverter.convert(this.dataTypes[columnIndex], dataType, this.values[columnIndex]);
        this.dataTypes[columnIndex] = dataType;
        return true;
    }

    @Override
    public void transferType(ZoneId zoneId) throws QueryProcessException {
        for (int i = 0; i < this.measurementSchemas.length; ++i) {
            if (this.measurementSchemas[i] == null) {
                if (!IoTDBDescriptor.getInstance().getConfig().isEnablePartialInsert()) {
                    throw new QueryProcessException((IoTDBException)new PathNotExistException(this.devicePath.getFullPath() + '.' + this.measurements[i]));
                }
                this.markFailedMeasurement(i, (Exception)((Object)new QueryProcessException((IoTDBException)new PathNotExistException(this.devicePath.getFullPath() + '.' + this.measurements[i]))));
                continue;
            }
            this.dataTypes[i] = this.measurementSchemas[i].getType();
            try {
                this.values[i] = ValueConverter.parse(this.values[i].toString(), this.dataTypes[i]);
                continue;
            }
            catch (Exception e) {
                PipeLogger.log(arg_0 -> ((Logger)LOGGER).warn(arg_0), (String)"data type of %s.%s is not consistent, registered type %s, inserting timestamp %s, value %s", (Object[])new Object[]{this.devicePath, this.measurements[i], this.dataTypes[i], this.time, this.values[i]});
                if (!IoTDBDescriptor.getInstance().getConfig().isEnablePartialInsert()) {
                    throw e;
                }
                this.markFailedMeasurement(i, e);
            }
        }
        this.isNeedInferType = false;
    }
}

