/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.event.batch;

import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionPipeEventBatchSegmentLock {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionPipeEventBatchSegmentLock.class);
    private static final int SEGMENT_LOCK_MIN_SIZE = 32;
    private static final int SEGMENT_LOCK_MAX_SIZE = 128;
    private volatile ReentrantLock[] locks;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initIfNecessary() {
        if (this.locks == null) {
            SubscriptionPipeEventBatchSegmentLock subscriptionPipeEventBatchSegmentLock = this;
            synchronized (subscriptionPipeEventBatchSegmentLock) {
                if (this.locks == null) {
                    int lockSegmentSize = 32;
                    try {
                        lockSegmentSize = StorageEngine.getInstance().getAllDataRegionIds().size();
                    }
                    catch (Exception e) {
                        LOGGER.warn("Cannot get data region ids, use default lock segment size: {}", (Object)lockSegmentSize);
                    }
                    lockSegmentSize = Math.min(128, lockSegmentSize);
                    lockSegmentSize = Math.max(32, lockSegmentSize);
                    ReentrantLock[] tmpLocks = new ReentrantLock[lockSegmentSize];
                    for (int i = 0; i < tmpLocks.length; ++i) {
                        tmpLocks[i] = new ReentrantLock();
                    }
                    this.locks = tmpLocks;
                }
            }
        }
    }

    public void lock(int regionId) {
        this.initIfNecessary();
        this.locks[regionId % this.locks.length].lock();
    }

    public void unlock(int regionId) {
        this.initIfNecessary();
        this.locks[regionId % this.locks.length].unlock();
    }
}

