/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.nosql.async.vertx;

import com.google.common.base.Preconditions;
import io.vertx.core.Vertx;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.time.Duration;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.polaris.nosql.async.AsyncConfiguration;
import org.apache.polaris.nosql.async.AsyncExec;
import org.apache.polaris.nosql.async.Cancelable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@ApplicationScoped
class VertxAsyncExec
implements AsyncExec,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)VertxAsyncExec.class.getName());
    private static final Duration MAX_DURATION = Duration.ofDays(7L);
    public static final String EXECUTOR_THREAD_NAME_PREFIX = "VertxAsyncExec#";
    private final ThreadPoolExecutor executorService;
    private final Vertx vertx;
    private static final AtomicInteger POOL_ID = new AtomicInteger();
    private final int poolId = POOL_ID.incrementAndGet();
    private final AtomicInteger executorThreadId = new AtomicInteger();
    private volatile boolean shutdown;
    private final Set<CancelableFuture<?>> tasks = ConcurrentHashMap.newKeySet();

    @Inject
    VertxAsyncExec(Vertx vertx, AsyncConfiguration asyncConfiguration) {
        this.vertx = vertx;
        this.executorService = new ThreadPoolExecutor(0, asyncConfiguration.maxThreads().orElse(AsyncConfiguration.DEFAULT_MAX_THREADS), asyncConfiguration.threadKeepAlive().orElse(AsyncConfiguration.DEFAULT_THREAD_KEEP_ALIVE).toMillis(), TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), r -> {
            Thread t = new Thread(r, EXECUTOR_THREAD_NAME_PREFIX + this.poolId + "-" + this.executorThreadId.incrementAndGet());
            t.setDaemon(true);
            return t;
        }, (r, executor) -> {
            Future<Object> future = null;
            if (r instanceof CancelableFuture) {
                CancelableFuture cancelable = (CancelableFuture)r;
                cancelable.cancelTimer();
                future = cancelable.completable;
            } else if (r instanceof Future) {
                Future f = (Future)((Object)r);
                future = f;
            }
            if (future != null && future.isDone()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(this.rejectedMessage(r, executor));
                }
                return;
            }
            String msg = this.rejectedMessage(r, executor);
            RejectedExecutionException ex = new RejectedExecutionException(msg);
            LOGGER.error(msg);
            throw ex;
        });
        this.executorService.allowCoreThreadTimeOut(true);
        LOGGER.debug("VertxAsyncExec initialized with pool ID {}", (Object)this.poolId);
    }

    private String rejectedMessage(Runnable r, ThreadPoolExecutor executor) {
        return String.format("Runnable '%s' rejected against pool ID %s / '%s'", r, this.poolId, executor);
    }

    @Override
    @PreDestroy
    public void close() {
        this.shutdown = true;
        LOGGER.debug("Shutting down VertxAsyncExec {} / '{}'", (Object)this.poolId, (Object)this.executorService);
        this.tasks.forEach(CancelableFuture::cancel);
        this.tasks.clear();
        this.executorService.shutdownNow();
        try {
            this.executorService.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    public <R> Cancelable<R> schedule(Callable<R> callable, Duration delay) {
        Preconditions.checkState((!this.shutdown ? 1 : 0) != 0, (String)"Must not schedule new tasks after shutdown of pool %s", (int)this.poolId);
        Preconditions.checkArgument((delay.compareTo(MAX_DURATION) < 0 ? 1 : 0) != 0, (String)"Delay is limited to %s", (Object)MAX_DURATION);
        CancelableFuture<R> cf = new CancelableFuture<R>(callable, Math.max(delay.toMillis(), 0L));
        this.tasks.add(cf);
        return cf;
    }

    public Cancelable<Void> schedulePeriodic(Runnable runnable, Duration initialDelay, Duration delay) {
        Preconditions.checkState((!this.shutdown ? 1 : 0) != 0, (String)"Must not schedule new tasks after shutdown of pool %s", (int)this.poolId);
        Preconditions.checkArgument((boolean)delay.isPositive(), (Object)"Delay must not be zero or negative");
        Preconditions.checkArgument((initialDelay.compareTo(MAX_DURATION) < 0 ? 1 : 0) != 0, (String)"Initial delay is limited to %s", (Object)MAX_DURATION);
        Preconditions.checkArgument((delay.compareTo(MAX_DURATION) < 0 ? 1 : 0) != 0, (String)"Delay is limited to %s", (Object)MAX_DURATION);
        CancelableFuture<Void> cf = new CancelableFuture<Void>(runnable, Math.max(initialDelay.toMillis(), 0L), Math.max(delay.toMillis(), 1L));
        this.tasks.add(cf);
        return cf;
    }

    public String toString() {
        return "VertxAsyncExec with pool ID " + this.poolId + " backed by " + String.valueOf(this.executorService);
    }

    private final class CancelableFuture<R>
    implements Cancelable<R>,
    Runnable {
        private final long timerId;
        private final boolean hasTimerId;
        private final CompletableFuture<R> completable = new CompletableFuture();
        private final Runnable runnable;
        private final Callable<R> callable;
        private final boolean periodic;
        private final AtomicBoolean running = new AtomicBoolean(false);
        private final AtomicReference<Future<?>> runningFuture = new AtomicReference();

        CancelableFuture(Runnable runnable, long initialMillis, long delayMillis) {
            initialMillis = Math.max(initialMillis, 1L);
            delayMillis = Math.max(delayMillis, 1L);
            this.runnable = Objects.requireNonNull(runnable, "Runnable must not be null");
            this.callable = this::runnable;
            this.timerId = VertxAsyncExec.this.vertx.setPeriodic(initialMillis, delayMillis, this::execAsync);
            this.hasTimerId = true;
            this.periodic = true;
        }

        CancelableFuture(Callable<R> callable, long delayMillis) {
            this.runnable = null;
            this.callable = Objects.requireNonNull(callable, "Callable must not be null");
            this.periodic = false;
            if (delayMillis > 0L) {
                this.hasTimerId = true;
                this.timerId = VertxAsyncExec.this.vertx.setTimer(delayMillis, this::execAsync);
            } else {
                this.hasTimerId = false;
                this.timerId = 0L;
                this.execAsync(-1L);
            }
        }

        private R runnable() {
            this.runnable.run();
            return null;
        }

        void execAsync(long unused) {
            if (this.cancelledOrShutdown()) {
                this.cancel();
                return;
            }
            if (this.periodic && this.running.get()) {
                return;
            }
            try {
                Future<?> f = VertxAsyncExec.this.executorService.submit(this);
                this.runningFuture.set(f);
            }
            catch (RejectedExecutionException rex) {
                this.completable.completeExceptionally(rex);
                this.cancel();
            }
        }

        @Override
        public void run() {
            if (this.cancelledOrShutdown()) {
                this.cancel();
                return;
            }
            if (this.periodic && !this.running.compareAndSet(false, true)) {
                return;
            }
            try {
                R r = this.callable.call();
                if (!this.periodic) {
                    this.completable.complete(r);
                    VertxAsyncExec.this.tasks.remove(this);
                }
            }
            catch (Throwable e) {
                this.completable.completeExceptionally(e);
                this.cancelTimer();
                VertxAsyncExec.this.tasks.remove(this);
            }
            finally {
                this.runningFuture.set(null);
                if (this.periodic) {
                    this.running.set(false);
                }
                MDC.clear();
            }
        }

        private void cancelTimer() {
            if (this.hasTimerId) {
                VertxAsyncExec.this.vertx.cancelTimer(this.timerId);
            }
        }

        private boolean cancelledOrShutdown() {
            return this.completable.isCancelled() || VertxAsyncExec.this.shutdown;
        }

        public CompletionStage<R> completionStage() {
            return this.completable;
        }

        public void cancel() {
            this.cancelTimer();
            this.completable.cancel(false);
            Future f = this.runningFuture.getAndSet(null);
            if (f != null && !f.isDone()) {
                f.cancel(true);
            }
            VertxAsyncExec.this.tasks.remove(this);
        }

        public String toString() {
            if (this.runnable != null) {
                return "VertxAsyncExec.Completable: Runnable " + String.valueOf(this.runnable);
            }
            return "VertxAsyncExec.Completable: Callable " + String.valueOf(this.callable);
        }
    }
}

