/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.common.annotation.Blocking;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.basicconfig.ConfigUtil;
import io.smallrye.faulttolerance.config.BlockingConfig;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

public final class BlockingConfigImpl
implements BlockingConfig {
    private final Class<?> beanClass;
    private final MethodDescriptor method;
    private final boolean onMethod;
    private final String description;
    private final String configKey;
    private final Blocking instance;

    private BlockingConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.onMethod = method.annotationsPresentDirectly.contains(Blocking.class);
        this.description = method.method.toString();
        this.configKey = this.onMethod ? method.method.declaringClass.getName() + "/" + method.method.name : method.method.declaringClass.getName();
        this.instance = method.blocking;
    }

    public static BlockingConfigImpl create(FaultToleranceMethod method) {
        if (method.blocking == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled((String)"blocking.enabled", (String)"Blocking/enabled", (MethodDescriptor)method.method)) {
            return null;
        }
        return new BlockingConfigImpl(method);
    }

    public boolean isOnMethod() {
        return this.onMethod;
    }

    public Class<?> beanClass() {
        return this.beanClass;
    }

    public MethodDescriptor method() {
        return this.method;
    }

    public Class<? extends Annotation> annotationType() {
        return Blocking.class;
    }

    public void materialize() {
    }

    public FaultToleranceDefinitionException fail(String reason) {
        return new FaultToleranceDefinitionException("Invalid @Blocking on " + this.description + ": " + reason);
    }

    public FaultToleranceDefinitionException fail(String member, String reason) {
        return new FaultToleranceDefinitionException("Invalid @Blocking." + member + " on " + this.description + ": " + reason);
    }
}

