/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.asn1;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.kerby.asn1.Asn1Converter;
import org.apache.kerby.asn1.Asn1Dumper;
import org.apache.kerby.asn1.parse.Asn1ParseResult;
import org.apache.kerby.asn1.parse.Asn1Parser;
import org.apache.kerby.asn1.type.Asn1Type;
import org.apache.kerby.asn1.util.HexUtil;

public final class Asn1 {
    private Asn1() {
    }

    public static void encode(ByteBuffer buffer, Asn1Type value) throws IOException {
        value.encode(buffer);
    }

    public static byte[] encode(Asn1Type value) throws IOException {
        return value.encode();
    }

    public static Asn1Type decode(byte[] content) throws IOException {
        return Asn1.decode(ByteBuffer.wrap(content));
    }

    public static Asn1Type decode(ByteBuffer content) throws IOException {
        Asn1ParseResult parseResult = Asn1Parser.parse(content);
        return Asn1Converter.convert(parseResult, false);
    }

    public static void decode(byte[] content, Asn1Type value) throws IOException {
        value.decode(content);
    }

    public static void decode(ByteBuffer content, Asn1Type value) throws IOException {
        value.decode(content);
    }

    public static Asn1ParseResult parse(byte[] content) throws IOException {
        return Asn1.parse(ByteBuffer.wrap(content));
    }

    public static Asn1ParseResult parse(ByteBuffer content) throws IOException {
        return Asn1Parser.parse(content);
    }

    public static void dump(Asn1Type value) {
        Asn1Dumper dumper = new Asn1Dumper();
        dumper.dumpType(0, value);
        String output = dumper.output();
        System.out.println(output);
    }

    public static void parseAndDump(String hexStr) throws IOException {
        byte[] data = HexUtil.hex2bytes(hexStr);
        Asn1.parseAndDump(data);
    }

    public static void parseAndDump(ByteBuffer content) throws IOException {
        byte[] bytes = new byte[content.remaining()];
        content.get(bytes);
        Asn1.parseAndDump(bytes);
    }

    public static void parseAndDump(byte[] content) throws IOException {
        Asn1Dumper dumper = new Asn1Dumper();
        dumper.parseAndDump(content);
        String output = dumper.output();
        System.out.println(output);
    }

    public static void decodeAndDump(String hexStr) throws IOException {
        byte[] data = HexUtil.hex2bytes(hexStr);
        Asn1.decodeAndDump(data);
    }

    public static void decodeAndDump(ByteBuffer content) throws IOException {
        byte[] bytes = new byte[content.remaining()];
        content.get(bytes);
        Asn1.decodeAndDump(bytes);
    }

    public static void decodeAndDump(byte[] content) throws IOException {
        Asn1Dumper dumper = new Asn1Dumper();
        dumper.decodeAndDump(content);
        String output = dumper.output();
        System.out.println(output);
    }
}

