/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.plugin.subbroker;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.bifromq.plugin.subbroker.CheckReply;
import org.apache.bifromq.plugin.subbroker.CheckRequest;
import org.apache.bifromq.plugin.subbroker.DeliveryPack;
import org.apache.bifromq.plugin.subbroker.DeliveryPackage;
import org.apache.bifromq.plugin.subbroker.DeliveryReply;
import org.apache.bifromq.plugin.subbroker.DeliveryRequest;
import org.apache.bifromq.plugin.subbroker.DeliveryResult;
import org.apache.bifromq.plugin.subbroker.DeliveryResults;
import org.apache.bifromq.plugin.subbroker.IDeliverer;
import org.apache.bifromq.plugin.subbroker.ISubBroker;
import org.apache.bifromq.type.MatchInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NoInboxSubBroker
implements ISubBroker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NoInboxSubBroker.class);
    public static final ISubBroker INSTANCE = new NoInboxSubBroker();

    public int id() {
        return Integer.MIN_VALUE;
    }

    public CompletableFuture<CheckReply> check(CheckRequest request) {
        CheckReply.Builder replyBuilder = CheckReply.newBuilder();
        for (MatchInfo matchInfo : request.getMatchInfoList()) {
            replyBuilder.addCode(CheckReply.Code.NO_RECEIVER);
        }
        return CompletableFuture.completedFuture(replyBuilder.build());
    }

    public IDeliverer open(String delivererKey) {
        return new IDeliverer(){

            public CompletableFuture<DeliveryReply> deliver(DeliveryRequest request) {
                DeliveryReply.Builder replyBuilder = DeliveryReply.newBuilder().setCode(DeliveryReply.Code.OK);
                for (Map.Entry entry : request.getPackageMap().entrySet()) {
                    HashMap<MatchInfo, DeliveryResult.Code> results = new HashMap<MatchInfo, DeliveryResult.Code>();
                    for (DeliveryPack pack : ((DeliveryPackage)entry.getValue()).getPackList()) {
                        for (MatchInfo matchInfo2 : pack.getMatchInfoList()) {
                            results.put(matchInfo2, DeliveryResult.Code.NO_SUB);
                        }
                    }
                    DeliveryResults.Builder resultsBuilder = DeliveryResults.newBuilder();
                    results.forEach((matchInfo, code) -> resultsBuilder.addResult(DeliveryResult.newBuilder().setMatchInfo(matchInfo).setCode(code).build()));
                    replyBuilder.putResult((String)entry.getKey(), resultsBuilder.build());
                }
                return CompletableFuture.completedFuture(replyBuilder.build());
            }

            public void close() {
            }
        };
    }

    public void close() {
    }

    @Generated
    private NoInboxSubBroker() {
    }
}

