/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf.geojson;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import mil.nga.sf.Geometry;
import mil.nga.sf.geojson.GeometryType;
import mil.nga.sf.geojson.Point;
import mil.nga.sf.geojson.Position;

public class MultiPoint
extends mil.nga.sf.geojson.Geometry {
    private static final long serialVersionUID = 2L;
    private List<Point> points = null;

    public static MultiPoint fromCoordinates(List<Position> coordinates) {
        MultiPoint multiPoint = new MultiPoint();
        multiPoint.setCoordinates(coordinates);
        return multiPoint;
    }

    public MultiPoint() {
    }

    public MultiPoint(List<Point> points) {
        this.points = points;
    }

    public MultiPoint(mil.nga.sf.MultiPoint multiPoint) {
        this.setMultiPoint(multiPoint);
    }

    @Override
    public GeometryType getGeometryType() {
        return GeometryType.MULTIPOINT;
    }

    @Override
    public Geometry getGeometry() {
        return this.getMultiPoint();
    }

    public List<Position> getCoordinates() {
        ArrayList<Position> coordinates = new ArrayList<Position>();
        for (Point point : this.points) {
            coordinates.add(point.getCoordinates());
        }
        return coordinates;
    }

    public void setCoordinates(List<Position> coordinates) {
        this.points = new ArrayList<Point>();
        for (Position position : coordinates) {
            this.points.add(Point.fromCoordinates(position));
        }
    }

    @JsonIgnore
    public List<Point> getPoints() {
        return this.points;
    }

    public void setPoints(List<Point> points) {
        this.points = points;
    }

    @JsonIgnore
    public mil.nga.sf.MultiPoint getMultiPoint() {
        ArrayList<mil.nga.sf.Point> simplePoints = new ArrayList<mil.nga.sf.Point>();
        for (Point point : this.points) {
            simplePoints.add(point.getPoint());
        }
        return new mil.nga.sf.MultiPoint(simplePoints);
    }

    public void setMultiPoint(mil.nga.sf.MultiPoint multiPoint) {
        this.points = new ArrayList<Point>();
        for (mil.nga.sf.Point point : multiPoint.getPoints()) {
            this.points.add(new Point(point));
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.points == null ? 0 : this.points.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiPoint other = (MultiPoint)obj;
        return !(this.points == null ? other.points != null : !this.points.equals(other.points));
    }
}

