/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.transform.ExponentialTransform1D;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.LinearTransform1D;
import org.apache.sis.referencing.operation.transform.LogarithmicTransform1D;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Characters;
import org.apache.sis.util.StringBuilders;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.content.TransferFunctionType;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.util.FactoryException;

public class TransferFunction
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 185931909755748004L;
    private TransferFunctionType type = TransferFunctionType.LINEAR;
    private double base = 10.0;
    private double scale = 1.0;
    private double offset;
    private MathTransform1D transform;

    public boolean isIdentity() {
        return TransferFunctionType.LINEAR.equals((Object)this.type) && this.scale == 1.0 && this.offset == 0.0;
    }

    public TransferFunctionType getType() {
        return this.type;
    }

    public void setType(TransferFunctionType type) {
        ArgumentChecks.ensureNonNull((String)"type", (Object)type);
        this.type = type;
        this.transform = null;
    }

    public double getBase() {
        return TransferFunctionType.LINEAR.equals((Object)this.type) ? 1.0 : this.base;
    }

    public void setBase(double base) {
        ArgumentChecks.ensureStrictlyPositive((String)"base", (double)base);
        ArgumentChecks.ensureFinite((String)"base", (double)base);
        this.base = base;
        this.transform = null;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        ArgumentChecks.ensureFinite((String)"scale", (double)scale);
        if (scale == 0.0) {
            throw new IllegalArgumentException(Errors.format((short)45, (Object)"scale", (Object)scale));
        }
        this.scale = scale;
        this.transform = null;
    }

    public double getOffset() {
        return this.offset;
    }

    public void setOffset(double offset) {
        ArgumentChecks.ensureFinite((String)"offset", (double)offset);
        this.offset = offset;
        this.transform = null;
    }

    private MathTransform createAffineTransform(MathTransformFactory factory, boolean withScale) throws FactoryException {
        return factory.createAffineTransform((Matrix)new Matrix2(withScale ? this.scale : 0.0, this.offset, 0.0, 1.0));
    }

    public MathTransform createTransform(MathTransformFactory factory) throws FactoryException {
        Object mt;
        ArgumentChecks.ensureNonNull((String)"factory", (Object)factory);
        if (TransferFunctionType.LINEAR.equals((Object)this.type)) {
            mt = this.createAffineTransform(factory, true);
        } else if (TransferFunctionType.EXPONENTIAL.equals((Object)this.type)) {
            mt = ExponentialTransform1D.create(this.base, this.scale);
            if (this.offset != 0.0) {
                mt = factory.createConcatenatedTransform(mt, this.createAffineTransform(factory, false));
            }
        } else if (TransferFunctionType.LOGARITHMIC.equals((Object)this.type)) {
            mt = this.scale == 1.0 ? LogarithmicTransform1D.create(this.base, this.offset) : factory.createConcatenatedTransform((MathTransform)LogarithmicTransform1D.create(this.base, 0.0), this.createAffineTransform(factory, true));
        } else {
            throw new IllegalStateException(Errors.format((short)149, (Object)this.type));
        }
        return mt;
    }

    public MathTransform1D getTransform() {
        MathTransform1D mt = this.transform;
        if (mt == null) {
            if (TransferFunctionType.LINEAR.equals((Object)this.type)) {
                mt = LinearTransform1D.create(this.scale, this.offset);
            } else if (TransferFunctionType.EXPONENTIAL.equals((Object)this.type)) {
                mt = ExponentialTransform1D.create(this.base, this.scale);
                if (this.offset != 0.0) {
                    mt = MathTransforms.concatenate(mt, LinearTransform1D.create(null, this.offset));
                }
            } else if (TransferFunctionType.LOGARITHMIC.equals((Object)this.type)) {
                mt = this.scale == 1.0 ? LogarithmicTransform1D.create(this.base, this.offset) : MathTransforms.concatenate(LogarithmicTransform1D.create(this.base, 0.0), LinearTransform1D.create(this.scale, this.offset));
            } else {
                throw new IllegalStateException(Errors.format((short)149, (Object)this.type));
            }
            this.transform = mt;
        }
        return mt;
    }

    public void setTransform(MathTransform1D function) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull((String)"function", (Object)function);
        if (function instanceof LinearTransform) {
            this.setLinearTerms((LinearTransform)function);
            this.type = TransferFunctionType.LINEAR;
        } else if (function instanceof ExponentialTransform1D) {
            ExponentialTransform1D f = (ExponentialTransform1D)function;
            this.type = TransferFunctionType.EXPONENTIAL;
            this.base = f.base;
            this.scale = f.scale;
            this.offset = 0.0;
        } else if (function instanceof LogarithmicTransform1D) {
            LogarithmicTransform1D f = (LogarithmicTransform1D)function;
            this.type = TransferFunctionType.LOGARITHMIC;
            this.base = f.base();
            this.offset = f.offset();
            this.scale = 1.0;
        } else {
            LogarithmicTransform1D.Base10 log = LogarithmicTransform1D.Base10.INSTANCE;
            MathTransform1D f = MathTransforms.concatenate(function, log);
            if (f instanceof LinearTransform) {
                this.setLinearTerms((LinearTransform)f);
                this.type = TransferFunctionType.EXPONENTIAL;
                this.base = 10.0;
            } else {
                f = MathTransforms.concatenate(log.inverse(), function);
                if (f instanceof LinearTransform) {
                    this.setLinearTerms((LinearTransform)f);
                    this.type = TransferFunctionType.LOGARITHMIC;
                    this.base = 10.0;
                } else {
                    throw new IllegalArgumentException(Errors.format((short)149, function.getClass()));
                }
            }
        }
        this.transform = function;
    }

    private void setLinearTerms(LinearTransform function) throws IllegalArgumentException {
        Matrix m = function.getMatrix();
        int numRow = m.getNumRow();
        int numCol = m.getNumCol();
        if (numRow != 2 || numCol != 2) {
            Integer two = 2;
            throw new IllegalArgumentException(Errors.format((short)83, (Object)two, (Object)two, (Object)numRow, (Object)numCol));
        }
        this.scale = m.getElement(0, 0);
        this.offset = m.getElement(0, 1);
    }

    public TransferFunction clone() {
        try {
            return (TransferFunction)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder("y = ");
        if (this.scale != 1.0) {
            if (this.scale == -1.0) {
                b.append('\u2212');
            } else {
                StringBuilders.trimFractionalPart((StringBuilder)b.append(this.scale).append('\u22c5'));
            }
        }
        if (TransferFunctionType.LINEAR.equals((Object)this.type)) {
            b.append('x');
        } else if (TransferFunctionType.EXPONENTIAL.equals((Object)this.type)) {
            if (this.base == Math.E) {
                b.append('e');
            } else {
                StringBuilders.trimFractionalPart((StringBuilder)b.append(this.base));
            }
            b.append('\u02e3');
        } else if (TransferFunctionType.LOGARITHMIC.equals((Object)this.type)) {
            if (this.base == Math.E) {
                b.append("ln");
            } else {
                b.append('\u33d2');
                if (this.base != 10.0) {
                    int c = (int)this.base;
                    if ((double)c == this.base && c >= 0 && c <= 9) {
                        b.append(Characters.toSubScript((char)((char)(c - 48))));
                    } else {
                        StringBuilders.trimFractionalPart((StringBuilder)b.append(this.base));
                    }
                }
            }
            b.append('\u24b3');
        } else {
            b.append('?');
        }
        if (this.offset != 0.0) {
            StringBuilders.trimFractionalPart((StringBuilder)b.append(' ').append(this.offset < 0.0 ? (char)'\u2212' : '+').append(' ').append(Math.abs(this.offset)));
        }
        return b.toString();
    }
}

