/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.file;

import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.server.RouteUtil;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.file.AbstractBlockingHttpVfs;
import com.linecorp.armeria.server.file.HttpFile;
import com.linecorp.armeria.server.file.HttpFileBuilder;
import com.linecorp.armeria.server.file.MediaTypeResolver;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Clock;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.stream.Stream;

final class FileSystemHttpVfs
extends AbstractBlockingHttpVfs {
    private static final boolean FILE_SEPARATOR_IS_NOT_SLASH = File.separatorChar != '/';
    private final Path rootDir;

    FileSystemHttpVfs(Path rootDir) {
        super(true);
        this.rootDir = Objects.requireNonNull(rootDir, "rootDir").toAbsolutePath();
        if (!Files.exists(this.rootDir, new LinkOption[0]) || !Files.isDirectory(this.rootDir, new LinkOption[0])) {
            throw new IllegalArgumentException("rootDir: " + rootDir + " (not a directory");
        }
    }

    @Override
    protected HttpFile blockingGet(Executor fileReadExecutor, String path, Clock clock, @Nullable String contentEncoding, HttpHeaders additionalHeaders, MediaTypeResolver mediaTypeResolver) {
        path = FileSystemHttpVfs.normalizePath(path);
        HttpFileBuilder builder = HttpFile.builder(Paths.get(this.rootDir + path, new String[0]));
        return FileSystemHttpVfs.build(builder, clock, path, contentEncoding, additionalHeaders, mediaTypeResolver);
    }

    @Override
    protected boolean blockingCanList(Executor fileReadExecutor, String path) {
        path = FileSystemHttpVfs.normalizePath(path);
        Path fsPath = Paths.get(this.rootDir + path, new String[0]);
        return Files.isDirectory(fsPath, new LinkOption[0]) && Files.isReadable(fsPath);
    }

    @Override
    protected List<String> blockingList(Executor fileReadExecutor, String path) {
        List list;
        block8: {
            path = FileSystemHttpVfs.normalizePath(path);
            Stream<Path> stream = Files.list(Paths.get(this.rootDir + path, new String[0]));
            try {
                list = stream.filter(Files::isReadable).map(p -> {
                    String fileName = p.getFileName().toString();
                    return Files.isDirectory(p, new LinkOption[0]) ? fileName + '/' : fileName;
                }).sorted(String.CASE_INSENSITIVE_ORDER).collect(ImmutableList.toImmutableList());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return ImmutableList.of();
                }
            }
            stream.close();
        }
        return list;
    }

    private static String normalizePath(String path) {
        RouteUtil.ensureAbsolutePath(path, "path");
        if (FILE_SEPARATOR_IS_NOT_SLASH) {
            path = path.replace(File.separatorChar, '/');
        }
        return path;
    }

    static HttpFile build(HttpFileBuilder builder, Clock clock, String pathOrUri, @Nullable String contentEncoding, HttpHeaders additionalHeaders, MediaTypeResolver mediaTypeResolver) {
        builder.autoDetectedContentType(false);
        builder.clock(clock);
        builder.setHeaders((Iterable)additionalHeaders);
        MediaType contentType = mediaTypeResolver.guessFromPath(pathOrUri, contentEncoding);
        if (contentType != null) {
            builder.contentType(contentType);
        }
        if (contentEncoding != null) {
            builder.setHeader((CharSequence)HttpHeaderNames.CONTENT_ENCODING, contentEncoding);
        }
        return builder.build();
    }

    @Override
    public String meterTag() {
        return "file:" + this.rootDir;
    }
}

