/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.bouncycastle.pqc.jcajce.provider.xmss;

import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1Set;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.linecorp.armeria.internal.shaded.bouncycastle.pqc.asn1.XMSSKeyParams;
import com.linecorp.armeria.internal.shaded.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import com.linecorp.armeria.internal.shaded.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import com.linecorp.armeria.internal.shaded.bouncycastle.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import com.linecorp.armeria.internal.shaded.bouncycastle.pqc.jcajce.interfaces.XMSSPrivateKey;
import com.linecorp.armeria.internal.shaded.bouncycastle.util.Arrays;
import java.io.IOException;
import java.security.PrivateKey;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class BCXMSSPrivateKey
implements XMSSPrivateKey,
PrivateKey {
    private transient XMSSPrivateKeyParameters keyParams;
    private transient ASN1ObjectIdentifier treeDigest;
    private transient ASN1Set attributes;

    public BCXMSSPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.init(privateKeyInfo);
    }

    private void init(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.attributes = privateKeyInfo.getAttributes();
        XMSSKeyParams xMSSKeyParams = XMSSKeyParams.getInstance(privateKeyInfo.getPrivateKeyAlgorithm().getParameters());
        this.treeDigest = xMSSKeyParams.getTreeDigest().getAlgorithm();
        this.keyParams = (XMSSPrivateKeyParameters)PrivateKeyFactory.createKey(privateKeyInfo);
    }

    public String getAlgorithm() {
        return "XMSS";
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] getEncoded() {
        try {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(this.keyParams, this.attributes);
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCXMSSPrivateKey) {
            BCXMSSPrivateKey bCXMSSPrivateKey = (BCXMSSPrivateKey)object;
            return this.treeDigest.equals(bCXMSSPrivateKey.treeDigest) && Arrays.areEqual(this.keyParams.toByteArray(), bCXMSSPrivateKey.keyParams.toByteArray());
        }
        return false;
    }

    public int hashCode() {
        return this.treeDigest.hashCode() + 37 * Arrays.hashCode(this.keyParams.toByteArray());
    }
}

