/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute.message;

import org.apache.ignite.internal.compute.ComputeMessagesFactory;
import org.apache.ignite.internal.compute.message.JobStatesResponse;
import org.apache.ignite.internal.compute.message.JobStatesResponseBuilder;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;

class JobStatesResponseDeserializer
implements MessageDeserializer<JobStatesResponse> {
    private final JobStatesResponseBuilder msg;

    JobStatesResponseDeserializer(ComputeMessagesFactory messageFactory) {
        this.msg = messageFactory.jobStatesResponse();
    }

    public Class<JobStatesResponse> klass() {
        return JobStatesResponse.class;
    }

    public JobStatesResponse getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                byte[] tmp = reader.readByteArray("statesByteArray");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.statesByteArray(tmp);
                reader.incrementState();
            }
            case 1: {
                byte[] tmp = reader.readByteArray("throwableByteArray");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.throwableByteArray(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(JobStatesResponse.class);
    }
}

