/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.exp;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.exp.SqlScalar;
import org.apache.ignite.internal.sql.engine.exec.row.RowSchema;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.sql.engine.util.Primitives;
import org.apache.ignite.internal.sql.engine.util.RexUtils;
import org.apache.ignite.internal.sql.engine.util.TypeUtils;

class ValuesImplementor {
    private final JavaTypeFactory typeFactory;

    ValuesImplementor(JavaTypeFactory typeFactory) {
        this.typeFactory = typeFactory;
    }

    <RowT> SqlScalar<RowT, List<RowT>> implement(List<List<RexLiteral>> values, RelDataType rowType) {
        List typeList = RelOptUtil.getFieldTypeList((RelDataType)rowType);
        RowSchema rowSchema = TypeUtils.rowSchemaFromRelTypes(typeList);
        List<Class> types = Commons.transform(typeList, type -> Primitives.wrap((Class)this.typeFactory.getJavaClass(type)));
        return context -> {
            ArrayList results = new ArrayList(values.size());
            RowHandler.RowBuilder rowBuilder = context.rowHandler().factory(rowSchema).rowBuilder();
            for (List row : values) {
                for (int i = 0; i < types.size(); ++i) {
                    rowBuilder.addField(RexUtils.literalValue(context, (RexLiteral)row.get(i), (Class)types.get(i)));
                }
                results.add(rowBuilder.buildAndReset());
            }
            return results;
        };
    }
}

