/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hop.workflow.actions.pipeline;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.Mockito.doCallRealMethod;
import static org.mockito.Mockito.mock;

import org.junit.jupiter.api.Test;

class WorkflowEntryPipelineDialogTest {

  private static final String FILE_NAME = "TestPipeline.hpl";

  ActionPipelineDialog dialog;

  @Test
  void testEntryName() {
    dialog = mock(ActionPipelineDialog.class);
    doCallRealMethod().when(dialog).getEntryName(any());
    assertEquals(dialog.getEntryName(FILE_NAME), "${Internal.Entry.Current.Folder}/" + FILE_NAME);
  }
}
